import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudformationStackConfig extends TerraformMetaArguments {
    readonly capabilities?: string[];
    readonly disableRollback?: boolean;
    readonly iamRoleArn?: string;
    readonly name: string;
    readonly notificationArns?: string[];
    readonly onFailure?: string;
    readonly parameters?: {
        [key: string]: string;
    };
    readonly policyBody?: string;
    readonly policyUrl?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly templateBody?: string;
    readonly templateUrl?: string;
    readonly timeoutInMinutes?: number;
    /** timeouts block */
    readonly timeouts?: CloudformationStackTimeouts;
}
export interface CloudformationStackTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class CloudformationStack extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudformationStackConfig);
    private _capabilities?;
    get capabilities(): string[] | undefined;
    set capabilities(value: string[] | undefined);
    private _disableRollback?;
    get disableRollback(): boolean | undefined;
    set disableRollback(value: boolean | undefined);
    private _iamRoleArn?;
    get iamRoleArn(): string | undefined;
    set iamRoleArn(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _notificationArns?;
    get notificationArns(): string[] | undefined;
    set notificationArns(value: string[] | undefined);
    private _onFailure?;
    get onFailure(): string | undefined;
    set onFailure(value: string | undefined);
    outputs(key: string): string;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    } | undefined;
    set parameters(value: {
        [key: string]: string;
    } | undefined);
    private _policyBody?;
    get policyBody(): string | undefined;
    set policyBody(value: string | undefined);
    private _policyUrl?;
    get policyUrl(): string | undefined;
    set policyUrl(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _templateBody?;
    get templateBody(): string | undefined;
    set templateBody(value: string | undefined);
    private _templateUrl?;
    get templateUrl(): string | undefined;
    set templateUrl(value: string | undefined);
    private _timeoutInMinutes?;
    get timeoutInMinutes(): number | undefined;
    set timeoutInMinutes(value: number | undefined);
    private _timeouts?;
    get timeouts(): CloudformationStackTimeouts | undefined;
    set timeouts(value: CloudformationStackTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
