import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudfrontDistributionConfig extends TerraformMetaArguments {
    readonly aliases?: string[];
    readonly comment?: string;
    readonly defaultRootObject?: string;
    readonly enabled: boolean;
    readonly httpVersion?: string;
    readonly isIpv6Enabled?: boolean;
    readonly priceClass?: string;
    readonly retainOnDelete?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    readonly waitForDeployment?: boolean;
    readonly webAclId?: string;
    /** cache_behavior block */
    readonly cacheBehavior?: CloudfrontDistributionCacheBehavior[];
    /** custom_error_response block */
    readonly customErrorResponse?: CloudfrontDistributionCustomErrorResponse[];
    /** default_cache_behavior block */
    readonly defaultCacheBehavior: CloudfrontDistributionDefaultCacheBehavior[];
    /** logging_config block */
    readonly loggingConfig?: CloudfrontDistributionLoggingConfig[];
    /** ordered_cache_behavior block */
    readonly orderedCacheBehavior?: CloudfrontDistributionOrderedCacheBehavior[];
    /** origin block */
    readonly origin: CloudfrontDistributionOrigin[];
    /** origin_group block */
    readonly originGroup?: CloudfrontDistributionOriginGroup[];
    /** restrictions block */
    readonly restrictions: CloudfrontDistributionRestrictions[];
    /** viewer_certificate block */
    readonly viewerCertificate: CloudfrontDistributionViewerCertificate[];
}
export interface CloudfrontDistributionCacheBehaviorForwardedValuesCookies {
    readonly forward: string;
    readonly whitelistedNames?: string[];
}
export interface CloudfrontDistributionCacheBehaviorForwardedValues {
    readonly headers?: string[];
    readonly queryString: boolean;
    readonly queryStringCacheKeys?: string[];
    /** cookies block */
    readonly cookies: CloudfrontDistributionCacheBehaviorForwardedValuesCookies[];
}
export interface CloudfrontDistributionCacheBehaviorLambdaFunctionAssociation {
    readonly eventType: string;
    readonly includeBody?: boolean;
    readonly lambdaArn: string;
}
export interface CloudfrontDistributionCacheBehavior {
    readonly allowedMethods: string[];
    readonly cachedMethods: string[];
    readonly compress?: boolean;
    readonly defaultTtl?: number;
    readonly fieldLevelEncryptionId?: string;
    readonly maxTtl?: number;
    readonly minTtl?: number;
    readonly pathPattern: string;
    readonly smoothStreaming?: boolean;
    readonly targetOriginId: string;
    readonly trustedSigners?: string[];
    readonly viewerProtocolPolicy: string;
    /** forwarded_values block */
    readonly forwardedValues: CloudfrontDistributionCacheBehaviorForwardedValues[];
    /** lambda_function_association block */
    readonly lambdaFunctionAssociation?: CloudfrontDistributionCacheBehaviorLambdaFunctionAssociation[];
}
export interface CloudfrontDistributionCustomErrorResponse {
    readonly errorCachingMinTtl?: number;
    readonly errorCode: number;
    readonly responseCode?: number;
    readonly responsePagePath?: string;
}
export interface CloudfrontDistributionDefaultCacheBehaviorForwardedValuesCookies {
    readonly forward: string;
    readonly whitelistedNames?: string[];
}
export interface CloudfrontDistributionDefaultCacheBehaviorForwardedValues {
    readonly headers?: string[];
    readonly queryString: boolean;
    readonly queryStringCacheKeys?: string[];
    /** cookies block */
    readonly cookies: CloudfrontDistributionDefaultCacheBehaviorForwardedValuesCookies[];
}
export interface CloudfrontDistributionDefaultCacheBehaviorLambdaFunctionAssociation {
    readonly eventType: string;
    readonly includeBody?: boolean;
    readonly lambdaArn: string;
}
export interface CloudfrontDistributionDefaultCacheBehavior {
    readonly allowedMethods: string[];
    readonly cachedMethods: string[];
    readonly compress?: boolean;
    readonly defaultTtl?: number;
    readonly fieldLevelEncryptionId?: string;
    readonly maxTtl?: number;
    readonly minTtl?: number;
    readonly smoothStreaming?: boolean;
    readonly targetOriginId: string;
    readonly trustedSigners?: string[];
    readonly viewerProtocolPolicy: string;
    /** forwarded_values block */
    readonly forwardedValues: CloudfrontDistributionDefaultCacheBehaviorForwardedValues[];
    /** lambda_function_association block */
    readonly lambdaFunctionAssociation?: CloudfrontDistributionDefaultCacheBehaviorLambdaFunctionAssociation[];
}
export interface CloudfrontDistributionLoggingConfig {
    readonly bucket: string;
    readonly includeCookies?: boolean;
    readonly prefix?: string;
}
export interface CloudfrontDistributionOrderedCacheBehaviorForwardedValuesCookies {
    readonly forward: string;
    readonly whitelistedNames?: string[];
}
export interface CloudfrontDistributionOrderedCacheBehaviorForwardedValues {
    readonly headers?: string[];
    readonly queryString: boolean;
    readonly queryStringCacheKeys?: string[];
    /** cookies block */
    readonly cookies: CloudfrontDistributionOrderedCacheBehaviorForwardedValuesCookies[];
}
export interface CloudfrontDistributionOrderedCacheBehaviorLambdaFunctionAssociation {
    readonly eventType: string;
    readonly includeBody?: boolean;
    readonly lambdaArn: string;
}
export interface CloudfrontDistributionOrderedCacheBehavior {
    readonly allowedMethods: string[];
    readonly cachedMethods: string[];
    readonly compress?: boolean;
    readonly defaultTtl?: number;
    readonly fieldLevelEncryptionId?: string;
    readonly maxTtl?: number;
    readonly minTtl?: number;
    readonly pathPattern: string;
    readonly smoothStreaming?: boolean;
    readonly targetOriginId: string;
    readonly trustedSigners?: string[];
    readonly viewerProtocolPolicy: string;
    /** forwarded_values block */
    readonly forwardedValues: CloudfrontDistributionOrderedCacheBehaviorForwardedValues[];
    /** lambda_function_association block */
    readonly lambdaFunctionAssociation?: CloudfrontDistributionOrderedCacheBehaviorLambdaFunctionAssociation[];
}
export interface CloudfrontDistributionOriginCustomHeader {
    readonly name: string;
    readonly value: string;
}
export interface CloudfrontDistributionOriginCustomOriginConfig {
    readonly httpPort: number;
    readonly httpsPort: number;
    readonly originKeepaliveTimeout?: number;
    readonly originProtocolPolicy: string;
    readonly originReadTimeout?: number;
    readonly originSslProtocols: string[];
}
export interface CloudfrontDistributionOriginS3OriginConfig {
    readonly originAccessIdentity: string;
}
export interface CloudfrontDistributionOrigin {
    readonly domainName: string;
    readonly originId: string;
    readonly originPath?: string;
    /** custom_header block */
    readonly customHeader?: CloudfrontDistributionOriginCustomHeader[];
    /** custom_origin_config block */
    readonly customOriginConfig?: CloudfrontDistributionOriginCustomOriginConfig[];
    /** s3_origin_config block */
    readonly s3OriginConfig?: CloudfrontDistributionOriginS3OriginConfig[];
}
export interface CloudfrontDistributionOriginGroupFailoverCriteria {
    readonly statusCodes: number[];
}
export interface CloudfrontDistributionOriginGroupMember {
    readonly originId: string;
}
export interface CloudfrontDistributionOriginGroup {
    readonly originId: string;
    /** failover_criteria block */
    readonly failoverCriteria: CloudfrontDistributionOriginGroupFailoverCriteria[];
    /** member block */
    readonly member: CloudfrontDistributionOriginGroupMember[];
}
export interface CloudfrontDistributionRestrictionsGeoRestriction {
    readonly locations?: string[];
    readonly restrictionType: string;
}
export interface CloudfrontDistributionRestrictions {
    /** geo_restriction block */
    readonly geoRestriction: CloudfrontDistributionRestrictionsGeoRestriction[];
}
export interface CloudfrontDistributionViewerCertificate {
    readonly acmCertificateArn?: string;
    readonly cloudfrontDefaultCertificate?: boolean;
    readonly iamCertificateId?: string;
    readonly minimumProtocolVersion?: string;
    readonly sslSupportMethod?: string;
}
export declare class CloudfrontDistribution extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudfrontDistributionConfig);
    activeTrustedSigners(key: string): string;
    private _aliases?;
    get aliases(): string[] | undefined;
    set aliases(value: string[] | undefined);
    get arn(): string;
    get callerReference(): string;
    private _comment?;
    get comment(): string | undefined;
    set comment(value: string | undefined);
    private _defaultRootObject?;
    get defaultRootObject(): string | undefined;
    set defaultRootObject(value: string | undefined);
    get domainName(): string;
    private _enabled;
    get enabled(): boolean;
    set enabled(value: boolean);
    get etag(): string;
    get hostedZoneId(): string;
    private _httpVersion?;
    get httpVersion(): string | undefined;
    set httpVersion(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get inProgressValidationBatches(): number;
    private _isIpv6Enabled?;
    get isIpv6Enabled(): boolean | undefined;
    set isIpv6Enabled(value: boolean | undefined);
    get lastModifiedTime(): string;
    private _priceClass?;
    get priceClass(): string | undefined;
    set priceClass(value: string | undefined);
    private _retainOnDelete?;
    get retainOnDelete(): boolean | undefined;
    set retainOnDelete(value: boolean | undefined);
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _waitForDeployment?;
    get waitForDeployment(): boolean | undefined;
    set waitForDeployment(value: boolean | undefined);
    private _webAclId?;
    get webAclId(): string | undefined;
    set webAclId(value: string | undefined);
    private _cacheBehavior?;
    get cacheBehavior(): CloudfrontDistributionCacheBehavior[] | undefined;
    set cacheBehavior(value: CloudfrontDistributionCacheBehavior[] | undefined);
    private _customErrorResponse?;
    get customErrorResponse(): CloudfrontDistributionCustomErrorResponse[] | undefined;
    set customErrorResponse(value: CloudfrontDistributionCustomErrorResponse[] | undefined);
    private _defaultCacheBehavior;
    get defaultCacheBehavior(): CloudfrontDistributionDefaultCacheBehavior[];
    set defaultCacheBehavior(value: CloudfrontDistributionDefaultCacheBehavior[]);
    private _loggingConfig?;
    get loggingConfig(): CloudfrontDistributionLoggingConfig[] | undefined;
    set loggingConfig(value: CloudfrontDistributionLoggingConfig[] | undefined);
    private _orderedCacheBehavior?;
    get orderedCacheBehavior(): CloudfrontDistributionOrderedCacheBehavior[] | undefined;
    set orderedCacheBehavior(value: CloudfrontDistributionOrderedCacheBehavior[] | undefined);
    private _origin;
    get origin(): CloudfrontDistributionOrigin[];
    set origin(value: CloudfrontDistributionOrigin[]);
    private _originGroup?;
    get originGroup(): CloudfrontDistributionOriginGroup[] | undefined;
    set originGroup(value: CloudfrontDistributionOriginGroup[] | undefined);
    private _restrictions;
    get restrictions(): CloudfrontDistributionRestrictions[];
    set restrictions(value: CloudfrontDistributionRestrictions[]);
    private _viewerCertificate;
    get viewerCertificate(): CloudfrontDistributionViewerCertificate[];
    set viewerCertificate(value: CloudfrontDistributionViewerCertificate[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
