"use strict";
// https://www.terraform.io/docs/providers/aws/r/cloudfront_distribution.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudfrontDistribution = void 0;
const cdktf_1 = require("cdktf");
const cdktf_2 = require("cdktf");
// Resource
class CloudfrontDistribution extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_cloudfront_distribution',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._aliases = config.aliases;
        this._comment = config.comment;
        this._defaultRootObject = config.defaultRootObject;
        this._enabled = config.enabled;
        this._httpVersion = config.httpVersion;
        this._isIpv6Enabled = config.isIpv6Enabled;
        this._priceClass = config.priceClass;
        this._retainOnDelete = config.retainOnDelete;
        this._tags = config.tags;
        this._waitForDeployment = config.waitForDeployment;
        this._webAclId = config.webAclId;
        this._cacheBehavior = config.cacheBehavior;
        this._customErrorResponse = config.customErrorResponse;
        this._defaultCacheBehavior = config.defaultCacheBehavior;
        this._loggingConfig = config.loggingConfig;
        this._orderedCacheBehavior = config.orderedCacheBehavior;
        this._origin = config.origin;
        this._originGroup = config.originGroup;
        this._restrictions = config.restrictions;
        this._viewerCertificate = config.viewerCertificate;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // active_trusted_signers - computed: true, optional: false, required: true
    activeTrustedSigners(key) {
        return new cdktf_2.StringMap(this, 'active_trusted_signers').lookup(key);
    }
    get aliases() {
        return this._aliases;
    }
    set aliases(value) {
        this._aliases = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    // caller_reference - computed: true, optional: false, required: true
    get callerReference() {
        return this.getStringAttribute('caller_reference');
    }
    get comment() {
        return this._comment;
    }
    set comment(value) {
        this._comment = value;
    }
    get defaultRootObject() {
        return this._defaultRootObject;
    }
    set defaultRootObject(value) {
        this._defaultRootObject = value;
    }
    // domain_name - computed: true, optional: false, required: true
    get domainName() {
        return this.getStringAttribute('domain_name');
    }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        this._enabled = value;
    }
    // etag - computed: true, optional: false, required: true
    get etag() {
        return this.getStringAttribute('etag');
    }
    // hosted_zone_id - computed: true, optional: false, required: true
    get hostedZoneId() {
        return this.getStringAttribute('hosted_zone_id');
    }
    get httpVersion() {
        return this._httpVersion;
    }
    set httpVersion(value) {
        this._httpVersion = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    // in_progress_validation_batches - computed: true, optional: false, required: true
    get inProgressValidationBatches() {
        return this.getNumberAttribute('in_progress_validation_batches');
    }
    get isIpv6Enabled() {
        return this._isIpv6Enabled;
    }
    set isIpv6Enabled(value) {
        this._isIpv6Enabled = value;
    }
    // last_modified_time - computed: true, optional: false, required: true
    get lastModifiedTime() {
        return this.getStringAttribute('last_modified_time');
    }
    get priceClass() {
        return this._priceClass;
    }
    set priceClass(value) {
        this._priceClass = value;
    }
    get retainOnDelete() {
        return this._retainOnDelete;
    }
    set retainOnDelete(value) {
        this._retainOnDelete = value;
    }
    // status - computed: true, optional: false, required: true
    get status() {
        return this.getStringAttribute('status');
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get waitForDeployment() {
        return this._waitForDeployment;
    }
    set waitForDeployment(value) {
        this._waitForDeployment = value;
    }
    get webAclId() {
        return this._webAclId;
    }
    set webAclId(value) {
        this._webAclId = value;
    }
    get cacheBehavior() {
        return this._cacheBehavior;
    }
    set cacheBehavior(value) {
        this._cacheBehavior = value;
    }
    get customErrorResponse() {
        return this._customErrorResponse;
    }
    set customErrorResponse(value) {
        this._customErrorResponse = value;
    }
    get defaultCacheBehavior() {
        return this._defaultCacheBehavior;
    }
    set defaultCacheBehavior(value) {
        this._defaultCacheBehavior = value;
    }
    get loggingConfig() {
        return this._loggingConfig;
    }
    set loggingConfig(value) {
        this._loggingConfig = value;
    }
    get orderedCacheBehavior() {
        return this._orderedCacheBehavior;
    }
    set orderedCacheBehavior(value) {
        this._orderedCacheBehavior = value;
    }
    get origin() {
        return this._origin;
    }
    set origin(value) {
        this._origin = value;
    }
    get originGroup() {
        return this._originGroup;
    }
    set originGroup(value) {
        this._originGroup = value;
    }
    get restrictions() {
        return this._restrictions;
    }
    set restrictions(value) {
        this._restrictions = value;
    }
    get viewerCertificate() {
        return this._viewerCertificate;
    }
    set viewerCertificate(value) {
        this._viewerCertificate = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            aliases: this._aliases,
            comment: this._comment,
            default_root_object: this._defaultRootObject,
            enabled: this._enabled,
            http_version: this._httpVersion,
            is_ipv6_enabled: this._isIpv6Enabled,
            price_class: this._priceClass,
            retain_on_delete: this._retainOnDelete,
            tags: this._tags,
            wait_for_deployment: this._waitForDeployment,
            web_acl_id: this._webAclId,
            cache_behavior: this._cacheBehavior,
            custom_error_response: this._customErrorResponse,
            default_cache_behavior: this._defaultCacheBehavior,
            logging_config: this._loggingConfig,
            ordered_cache_behavior: this._orderedCacheBehavior,
            origin: this._origin,
            origin_group: this._originGroup,
            restrictions: this._restrictions,
            viewer_certificate: this._viewerCertificate,
        };
    }
}
exports.CloudfrontDistribution = CloudfrontDistribution;
//# sourceMappingURL=data:application/json;base64,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