import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudfrontOriginAccessIdentityConfig extends TerraformMetaArguments {
    readonly comment?: string;
}
export declare class CloudfrontOriginAccessIdentity extends TerraformResource {
    constructor(scope: Construct, id: string, config?: CloudfrontOriginAccessIdentityConfig);
    get callerReference(): string;
    get cloudfrontAccessIdentityPath(): string;
    private _comment?;
    get comment(): string | undefined;
    set comment(value: string | undefined);
    get etag(): string;
    get iamArn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get s3CanonicalUserId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
