import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudfrontPublicKeyConfig extends TerraformMetaArguments {
    readonly comment?: string;
    readonly encodedKey: string;
    readonly name?: string;
    readonly namePrefix?: string;
}
export declare class CloudfrontPublicKey extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudfrontPublicKeyConfig);
    get callerReference(): string;
    private _comment?;
    get comment(): string | undefined;
    set comment(value: string | undefined);
    private _encodedKey;
    get encodedKey(): string;
    set encodedKey(value: string);
    get etag(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
