import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface CloudhsmV2ClusterConfig extends TerraformMetaArguments {
    readonly hsmType: string;
    readonly sourceBackupIdentifier?: string;
    readonly subnetIds: string[];
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: CloudhsmV2ClusterTimeouts;
}
export declare class CloudhsmV2ClusterClusterCertificates extends ComplexComputedList {
    get awsHardwareCertificate(): string;
    get clusterCertificate(): string;
    get clusterCsr(): string;
    get hsmCertificate(): string;
    get manufacturerHardwareCertificate(): string;
}
export interface CloudhsmV2ClusterTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class CloudhsmV2Cluster extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudhsmV2ClusterConfig);
    clusterCertificates(index: string): CloudhsmV2ClusterClusterCertificates;
    get clusterId(): string;
    get clusterState(): string;
    private _hsmType;
    get hsmType(): string;
    set hsmType(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get securityGroupId(): string;
    private _sourceBackupIdentifier?;
    get sourceBackupIdentifier(): string | undefined;
    set sourceBackupIdentifier(value: string | undefined);
    private _subnetIds;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    private _timeouts?;
    get timeouts(): CloudhsmV2ClusterTimeouts | undefined;
    set timeouts(value: CloudhsmV2ClusterTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
