import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudhsmV2HsmConfig extends TerraformMetaArguments {
    readonly availabilityZone?: string;
    readonly clusterId: string;
    readonly ipAddress?: string;
    readonly subnetId?: string;
    /** timeouts block */
    readonly timeouts?: CloudhsmV2HsmTimeouts;
}
export interface CloudhsmV2HsmTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class CloudhsmV2Hsm extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudhsmV2HsmConfig);
    private _availabilityZone?;
    get availabilityZone(): string | undefined;
    set availabilityZone(value: string | undefined);
    private _clusterId;
    get clusterId(): string;
    set clusterId(value: string);
    get hsmEniId(): string;
    get hsmId(): string;
    get hsmState(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ipAddress?;
    get ipAddress(): string | undefined;
    set ipAddress(value: string | undefined);
    private _subnetId?;
    get subnetId(): string | undefined;
    set subnetId(value: string | undefined);
    private _timeouts?;
    get timeouts(): CloudhsmV2HsmTimeouts | undefined;
    set timeouts(value: CloudhsmV2HsmTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
