import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudtrailConfig extends TerraformMetaArguments {
    readonly cloudWatchLogsGroupArn?: string;
    readonly cloudWatchLogsRoleArn?: string;
    readonly enableLogFileValidation?: boolean;
    readonly enableLogging?: boolean;
    readonly includeGlobalServiceEvents?: boolean;
    readonly isMultiRegionTrail?: boolean;
    readonly isOrganizationTrail?: boolean;
    readonly kmsKeyId?: string;
    readonly name: string;
    readonly s3BucketName: string;
    readonly s3KeyPrefix?: string;
    readonly snsTopicName?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** event_selector block */
    readonly eventSelector?: CloudtrailEventSelector[];
}
export interface CloudtrailEventSelectorDataResource {
    readonly type: string;
    readonly values: string[];
}
export interface CloudtrailEventSelector {
    readonly includeManagementEvents?: boolean;
    readonly readWriteType?: string;
    /** data_resource block */
    readonly dataResource?: CloudtrailEventSelectorDataResource[];
}
export declare class Cloudtrail extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudtrailConfig);
    get arn(): string;
    private _cloudWatchLogsGroupArn?;
    get cloudWatchLogsGroupArn(): string | undefined;
    set cloudWatchLogsGroupArn(value: string | undefined);
    private _cloudWatchLogsRoleArn?;
    get cloudWatchLogsRoleArn(): string | undefined;
    set cloudWatchLogsRoleArn(value: string | undefined);
    private _enableLogFileValidation?;
    get enableLogFileValidation(): boolean | undefined;
    set enableLogFileValidation(value: boolean | undefined);
    private _enableLogging?;
    get enableLogging(): boolean | undefined;
    set enableLogging(value: boolean | undefined);
    get homeRegion(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _includeGlobalServiceEvents?;
    get includeGlobalServiceEvents(): boolean | undefined;
    set includeGlobalServiceEvents(value: boolean | undefined);
    private _isMultiRegionTrail?;
    get isMultiRegionTrail(): boolean | undefined;
    set isMultiRegionTrail(value: boolean | undefined);
    private _isOrganizationTrail?;
    get isOrganizationTrail(): boolean | undefined;
    set isOrganizationTrail(value: boolean | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _s3BucketName;
    get s3BucketName(): string;
    set s3BucketName(value: string);
    private _s3KeyPrefix?;
    get s3KeyPrefix(): string | undefined;
    set s3KeyPrefix(value: string | undefined);
    private _snsTopicName?;
    get snsTopicName(): string | undefined;
    set snsTopicName(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _eventSelector?;
    get eventSelector(): CloudtrailEventSelector[] | undefined;
    set eventSelector(value: CloudtrailEventSelector[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
