"use strict";
// https://www.terraform.io/docs/providers/aws/r/cloudtrail.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cloudtrail = void 0;
const cdktf_1 = require("cdktf");
// Resource
class Cloudtrail extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_cloudtrail',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._cloudWatchLogsGroupArn = config.cloudWatchLogsGroupArn;
        this._cloudWatchLogsRoleArn = config.cloudWatchLogsRoleArn;
        this._enableLogFileValidation = config.enableLogFileValidation;
        this._enableLogging = config.enableLogging;
        this._includeGlobalServiceEvents = config.includeGlobalServiceEvents;
        this._isMultiRegionTrail = config.isMultiRegionTrail;
        this._isOrganizationTrail = config.isOrganizationTrail;
        this._kmsKeyId = config.kmsKeyId;
        this._name = config.name;
        this._s3BucketName = config.s3BucketName;
        this._s3KeyPrefix = config.s3KeyPrefix;
        this._snsTopicName = config.snsTopicName;
        this._tags = config.tags;
        this._eventSelector = config.eventSelector;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get cloudWatchLogsGroupArn() {
        return this._cloudWatchLogsGroupArn;
    }
    set cloudWatchLogsGroupArn(value) {
        this._cloudWatchLogsGroupArn = value;
    }
    get cloudWatchLogsRoleArn() {
        return this._cloudWatchLogsRoleArn;
    }
    set cloudWatchLogsRoleArn(value) {
        this._cloudWatchLogsRoleArn = value;
    }
    get enableLogFileValidation() {
        return this._enableLogFileValidation;
    }
    set enableLogFileValidation(value) {
        this._enableLogFileValidation = value;
    }
    get enableLogging() {
        return this._enableLogging;
    }
    set enableLogging(value) {
        this._enableLogging = value;
    }
    // home_region - computed: true, optional: false, required: true
    get homeRegion() {
        return this.getStringAttribute('home_region');
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get includeGlobalServiceEvents() {
        return this._includeGlobalServiceEvents;
    }
    set includeGlobalServiceEvents(value) {
        this._includeGlobalServiceEvents = value;
    }
    get isMultiRegionTrail() {
        return this._isMultiRegionTrail;
    }
    set isMultiRegionTrail(value) {
        this._isMultiRegionTrail = value;
    }
    get isOrganizationTrail() {
        return this._isOrganizationTrail;
    }
    set isOrganizationTrail(value) {
        this._isOrganizationTrail = value;
    }
    get kmsKeyId() {
        return this._kmsKeyId;
    }
    set kmsKeyId(value) {
        this._kmsKeyId = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get s3BucketName() {
        return this._s3BucketName;
    }
    set s3BucketName(value) {
        this._s3BucketName = value;
    }
    get s3KeyPrefix() {
        return this._s3KeyPrefix;
    }
    set s3KeyPrefix(value) {
        this._s3KeyPrefix = value;
    }
    get snsTopicName() {
        return this._snsTopicName;
    }
    set snsTopicName(value) {
        this._snsTopicName = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get eventSelector() {
        return this._eventSelector;
    }
    set eventSelector(value) {
        this._eventSelector = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cloud_watch_logs_group_arn: this._cloudWatchLogsGroupArn,
            cloud_watch_logs_role_arn: this._cloudWatchLogsRoleArn,
            enable_log_file_validation: this._enableLogFileValidation,
            enable_logging: this._enableLogging,
            include_global_service_events: this._includeGlobalServiceEvents,
            is_multi_region_trail: this._isMultiRegionTrail,
            is_organization_trail: this._isOrganizationTrail,
            kms_key_id: this._kmsKeyId,
            name: this._name,
            s3_bucket_name: this._s3BucketName,
            s3_key_prefix: this._s3KeyPrefix,
            sns_topic_name: this._snsTopicName,
            tags: this._tags,
            event_selector: this._eventSelector,
        };
    }
}
exports.Cloudtrail = Cloudtrail;
//# sourceMappingURL=data:application/json;base64,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