import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudwatchEventPermissionConfig extends TerraformMetaArguments {
    readonly action?: string;
    readonly principal: string;
    readonly statementId: string;
    /** condition block */
    readonly condition?: CloudwatchEventPermissionCondition[];
}
export interface CloudwatchEventPermissionCondition {
    readonly key: string;
    readonly type: string;
    readonly value: string;
}
export declare class CloudwatchEventPermission extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudwatchEventPermissionConfig);
    private _action?;
    get action(): string | undefined;
    set action(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _principal;
    get principal(): string;
    set principal(value: string);
    private _statementId;
    get statementId(): string;
    set statementId(value: string);
    private _condition?;
    get condition(): CloudwatchEventPermissionCondition[] | undefined;
    set condition(value: CloudwatchEventPermissionCondition[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
