import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudwatchEventRuleConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly eventPattern?: string;
    readonly isEnabled?: boolean;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly roleArn?: string;
    readonly scheduleExpression?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class CloudwatchEventRule extends TerraformResource {
    constructor(scope: Construct, id: string, config?: CloudwatchEventRuleConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _eventPattern?;
    get eventPattern(): string | undefined;
    set eventPattern(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | undefined;
    set isEnabled(value: boolean | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _roleArn?;
    get roleArn(): string | undefined;
    set roleArn(value: string | undefined);
    private _scheduleExpression?;
    get scheduleExpression(): string | undefined;
    set scheduleExpression(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
