import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudwatchEventTargetConfig extends TerraformMetaArguments {
    readonly arn: string;
    readonly input?: string;
    readonly inputPath?: string;
    readonly roleArn?: string;
    readonly rule: string;
    readonly targetId?: string;
    /** batch_target block */
    readonly batchTarget?: CloudwatchEventTargetBatchTarget[];
    /** ecs_target block */
    readonly ecsTarget?: CloudwatchEventTargetEcsTarget[];
    /** input_transformer block */
    readonly inputTransformer?: CloudwatchEventTargetInputTransformer[];
    /** kinesis_target block */
    readonly kinesisTarget?: CloudwatchEventTargetKinesisTarget[];
    /** run_command_targets block */
    readonly runCommandTargets?: CloudwatchEventTargetRunCommandTargets[];
    /** sqs_target block */
    readonly sqsTarget?: CloudwatchEventTargetSqsTarget[];
}
export interface CloudwatchEventTargetBatchTarget {
    readonly arraySize?: number;
    readonly jobAttempts?: number;
    readonly jobDefinition: string;
    readonly jobName: string;
}
export interface CloudwatchEventTargetEcsTargetNetworkConfiguration {
    readonly assignPublicIp?: boolean;
    readonly securityGroups?: string[];
    readonly subnets: string[];
}
export interface CloudwatchEventTargetEcsTarget {
    readonly group?: string;
    readonly launchType?: string;
    readonly platformVersion?: string;
    readonly taskCount?: number;
    readonly taskDefinitionArn: string;
    /** network_configuration block */
    readonly networkConfiguration?: CloudwatchEventTargetEcsTargetNetworkConfiguration[];
}
export interface CloudwatchEventTargetInputTransformer {
    readonly inputPaths?: {
        [key: string]: string;
    };
    readonly inputTemplate: string;
}
export interface CloudwatchEventTargetKinesisTarget {
    readonly partitionKeyPath?: string;
}
export interface CloudwatchEventTargetRunCommandTargets {
    readonly key: string;
    readonly values: string[];
}
export interface CloudwatchEventTargetSqsTarget {
    readonly messageGroupId?: string;
}
export declare class CloudwatchEventTarget extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudwatchEventTargetConfig);
    private _arn;
    get arn(): string;
    set arn(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _input?;
    get input(): string | undefined;
    set input(value: string | undefined);
    private _inputPath?;
    get inputPath(): string | undefined;
    set inputPath(value: string | undefined);
    private _roleArn?;
    get roleArn(): string | undefined;
    set roleArn(value: string | undefined);
    private _rule;
    get rule(): string;
    set rule(value: string);
    private _targetId?;
    get targetId(): string | undefined;
    set targetId(value: string | undefined);
    private _batchTarget?;
    get batchTarget(): CloudwatchEventTargetBatchTarget[] | undefined;
    set batchTarget(value: CloudwatchEventTargetBatchTarget[] | undefined);
    private _ecsTarget?;
    get ecsTarget(): CloudwatchEventTargetEcsTarget[] | undefined;
    set ecsTarget(value: CloudwatchEventTargetEcsTarget[] | undefined);
    private _inputTransformer?;
    get inputTransformer(): CloudwatchEventTargetInputTransformer[] | undefined;
    set inputTransformer(value: CloudwatchEventTargetInputTransformer[] | undefined);
    private _kinesisTarget?;
    get kinesisTarget(): CloudwatchEventTargetKinesisTarget[] | undefined;
    set kinesisTarget(value: CloudwatchEventTargetKinesisTarget[] | undefined);
    private _runCommandTargets?;
    get runCommandTargets(): CloudwatchEventTargetRunCommandTargets[] | undefined;
    set runCommandTargets(value: CloudwatchEventTargetRunCommandTargets[] | undefined);
    private _sqsTarget?;
    get sqsTarget(): CloudwatchEventTargetSqsTarget[] | undefined;
    set sqsTarget(value: CloudwatchEventTargetSqsTarget[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
