import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudwatchLogDestinationConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly roleArn: string;
    readonly targetArn: string;
}
export declare class CloudwatchLogDestination extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudwatchLogDestinationConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _roleArn;
    get roleArn(): string;
    set roleArn(value: string);
    private _targetArn;
    get targetArn(): string;
    set targetArn(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
