import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudwatchLogGroupConfig extends TerraformMetaArguments {
    readonly kmsKeyId?: string;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly retentionInDays?: number;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class CloudwatchLogGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config?: CloudwatchLogGroupConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _retentionInDays?;
    get retentionInDays(): number | undefined;
    set retentionInDays(value: number | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
