import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudwatchLogMetricFilterConfig extends TerraformMetaArguments {
    readonly logGroupName: string;
    readonly name: string;
    readonly pattern: string;
    /** metric_transformation block */
    readonly metricTransformation: CloudwatchLogMetricFilterMetricTransformation[];
}
export interface CloudwatchLogMetricFilterMetricTransformation {
    readonly defaultValue?: string;
    readonly name: string;
    readonly namespace: string;
    readonly value: string;
}
export declare class CloudwatchLogMetricFilter extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudwatchLogMetricFilterConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _logGroupName;
    get logGroupName(): string;
    set logGroupName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _pattern;
    get pattern(): string;
    set pattern(value: string);
    private _metricTransformation;
    get metricTransformation(): CloudwatchLogMetricFilterMetricTransformation[];
    set metricTransformation(value: CloudwatchLogMetricFilterMetricTransformation[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
