import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudwatchLogStreamConfig extends TerraformMetaArguments {
    readonly logGroupName: string;
    readonly name: string;
}
export declare class CloudwatchLogStream extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudwatchLogStreamConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _logGroupName;
    get logGroupName(): string;
    set logGroupName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
