import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudwatchLogSubscriptionFilterConfig extends TerraformMetaArguments {
    readonly destinationArn: string;
    readonly distribution?: string;
    readonly filterPattern: string;
    readonly logGroupName: string;
    readonly name: string;
    readonly roleArn?: string;
}
export declare class CloudwatchLogSubscriptionFilter extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudwatchLogSubscriptionFilterConfig);
    private _destinationArn;
    get destinationArn(): string;
    set destinationArn(value: string);
    private _distribution?;
    get distribution(): string | undefined;
    set distribution(value: string | undefined);
    private _filterPattern;
    get filterPattern(): string;
    set filterPattern(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _logGroupName;
    get logGroupName(): string;
    set logGroupName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _roleArn?;
    get roleArn(): string | undefined;
    set roleArn(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
