import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CloudwatchMetricAlarmConfig extends TerraformMetaArguments {
    readonly actionsEnabled?: boolean;
    readonly alarmActions?: string[];
    readonly alarmDescription?: string;
    readonly alarmName: string;
    readonly comparisonOperator: string;
    readonly datapointsToAlarm?: number;
    readonly dimensions?: {
        [key: string]: string;
    };
    readonly evaluateLowSampleCountPercentiles?: string;
    readonly evaluationPeriods: number;
    readonly extendedStatistic?: string;
    readonly insufficientDataActions?: string[];
    readonly metricName?: string;
    readonly namespace?: string;
    readonly okActions?: string[];
    readonly period?: number;
    readonly statistic?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly threshold?: number;
    readonly thresholdMetricId?: string;
    readonly treatMissingData?: string;
    readonly unit?: string;
    /** metric_query block */
    readonly metricQuery?: CloudwatchMetricAlarmMetricQuery[];
}
export interface CloudwatchMetricAlarmMetricQueryMetric {
    readonly dimensions?: {
        [key: string]: string;
    };
    readonly metricName: string;
    readonly namespace?: string;
    readonly period: number;
    readonly stat: string;
    readonly unit?: string;
}
export interface CloudwatchMetricAlarmMetricQuery {
    readonly expression?: string;
    readonly id: string;
    readonly label?: string;
    readonly returnData?: boolean;
    /** metric block */
    readonly metric?: CloudwatchMetricAlarmMetricQueryMetric[];
}
export declare class CloudwatchMetricAlarm extends TerraformResource {
    constructor(scope: Construct, id: string, config: CloudwatchMetricAlarmConfig);
    private _actionsEnabled?;
    get actionsEnabled(): boolean | undefined;
    set actionsEnabled(value: boolean | undefined);
    private _alarmActions?;
    get alarmActions(): string[] | undefined;
    set alarmActions(value: string[] | undefined);
    private _alarmDescription?;
    get alarmDescription(): string | undefined;
    set alarmDescription(value: string | undefined);
    private _alarmName;
    get alarmName(): string;
    set alarmName(value: string);
    get arn(): string;
    private _comparisonOperator;
    get comparisonOperator(): string;
    set comparisonOperator(value: string);
    private _datapointsToAlarm?;
    get datapointsToAlarm(): number | undefined;
    set datapointsToAlarm(value: number | undefined);
    private _dimensions?;
    get dimensions(): {
        [key: string]: string;
    } | undefined;
    set dimensions(value: {
        [key: string]: string;
    } | undefined);
    private _evaluateLowSampleCountPercentiles?;
    get evaluateLowSampleCountPercentiles(): string | undefined;
    set evaluateLowSampleCountPercentiles(value: string | undefined);
    private _evaluationPeriods;
    get evaluationPeriods(): number;
    set evaluationPeriods(value: number);
    private _extendedStatistic?;
    get extendedStatistic(): string | undefined;
    set extendedStatistic(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _insufficientDataActions?;
    get insufficientDataActions(): string[] | undefined;
    set insufficientDataActions(value: string[] | undefined);
    private _metricName?;
    get metricName(): string | undefined;
    set metricName(value: string | undefined);
    private _namespace?;
    get namespace(): string | undefined;
    set namespace(value: string | undefined);
    private _okActions?;
    get okActions(): string[] | undefined;
    set okActions(value: string[] | undefined);
    private _period?;
    get period(): number | undefined;
    set period(value: number | undefined);
    private _statistic?;
    get statistic(): string | undefined;
    set statistic(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _threshold?;
    get threshold(): number | undefined;
    set threshold(value: number | undefined);
    private _thresholdMetricId?;
    get thresholdMetricId(): string | undefined;
    set thresholdMetricId(value: string | undefined);
    private _treatMissingData?;
    get treatMissingData(): string | undefined;
    set treatMissingData(value: string | undefined);
    private _unit?;
    get unit(): string | undefined;
    set unit(value: string | undefined);
    private _metricQuery?;
    get metricQuery(): CloudwatchMetricAlarmMetricQuery[] | undefined;
    set metricQuery(value: CloudwatchMetricAlarmMetricQuery[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
