"use strict";
// https://www.terraform.io/docs/providers/aws/r/cloudwatch_metric_alarm.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudwatchMetricAlarm = void 0;
const cdktf_1 = require("cdktf");
// Resource
class CloudwatchMetricAlarm extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_cloudwatch_metric_alarm',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._actionsEnabled = config.actionsEnabled;
        this._alarmActions = config.alarmActions;
        this._alarmDescription = config.alarmDescription;
        this._alarmName = config.alarmName;
        this._comparisonOperator = config.comparisonOperator;
        this._datapointsToAlarm = config.datapointsToAlarm;
        this._dimensions = config.dimensions;
        this._evaluateLowSampleCountPercentiles = config.evaluateLowSampleCountPercentiles;
        this._evaluationPeriods = config.evaluationPeriods;
        this._extendedStatistic = config.extendedStatistic;
        this._insufficientDataActions = config.insufficientDataActions;
        this._metricName = config.metricName;
        this._namespace = config.namespace;
        this._okActions = config.okActions;
        this._period = config.period;
        this._statistic = config.statistic;
        this._tags = config.tags;
        this._threshold = config.threshold;
        this._thresholdMetricId = config.thresholdMetricId;
        this._treatMissingData = config.treatMissingData;
        this._unit = config.unit;
        this._metricQuery = config.metricQuery;
    }
    get actionsEnabled() {
        return this._actionsEnabled;
    }
    set actionsEnabled(value) {
        this._actionsEnabled = value;
    }
    get alarmActions() {
        return this._alarmActions;
    }
    set alarmActions(value) {
        this._alarmActions = value;
    }
    get alarmDescription() {
        return this._alarmDescription;
    }
    set alarmDescription(value) {
        this._alarmDescription = value;
    }
    get alarmName() {
        return this._alarmName;
    }
    set alarmName(value) {
        this._alarmName = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get comparisonOperator() {
        return this._comparisonOperator;
    }
    set comparisonOperator(value) {
        this._comparisonOperator = value;
    }
    get datapointsToAlarm() {
        return this._datapointsToAlarm;
    }
    set datapointsToAlarm(value) {
        this._datapointsToAlarm = value;
    }
    get dimensions() {
        return this._dimensions;
    }
    set dimensions(value) {
        this._dimensions = value;
    }
    get evaluateLowSampleCountPercentiles() {
        var _a;
        return (_a = this._evaluateLowSampleCountPercentiles) !== null && _a !== void 0 ? _a : this.getStringAttribute('evaluate_low_sample_count_percentiles');
    }
    set evaluateLowSampleCountPercentiles(value) {
        this._evaluateLowSampleCountPercentiles = value;
    }
    get evaluationPeriods() {
        return this._evaluationPeriods;
    }
    set evaluationPeriods(value) {
        this._evaluationPeriods = value;
    }
    get extendedStatistic() {
        return this._extendedStatistic;
    }
    set extendedStatistic(value) {
        this._extendedStatistic = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get insufficientDataActions() {
        return this._insufficientDataActions;
    }
    set insufficientDataActions(value) {
        this._insufficientDataActions = value;
    }
    get metricName() {
        return this._metricName;
    }
    set metricName(value) {
        this._metricName = value;
    }
    get namespace() {
        return this._namespace;
    }
    set namespace(value) {
        this._namespace = value;
    }
    get okActions() {
        return this._okActions;
    }
    set okActions(value) {
        this._okActions = value;
    }
    get period() {
        return this._period;
    }
    set period(value) {
        this._period = value;
    }
    get statistic() {
        return this._statistic;
    }
    set statistic(value) {
        this._statistic = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get threshold() {
        return this._threshold;
    }
    set threshold(value) {
        this._threshold = value;
    }
    get thresholdMetricId() {
        return this._thresholdMetricId;
    }
    set thresholdMetricId(value) {
        this._thresholdMetricId = value;
    }
    get treatMissingData() {
        return this._treatMissingData;
    }
    set treatMissingData(value) {
        this._treatMissingData = value;
    }
    get unit() {
        return this._unit;
    }
    set unit(value) {
        this._unit = value;
    }
    get metricQuery() {
        return this._metricQuery;
    }
    set metricQuery(value) {
        this._metricQuery = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            actions_enabled: this._actionsEnabled,
            alarm_actions: this._alarmActions,
            alarm_description: this._alarmDescription,
            alarm_name: this._alarmName,
            comparison_operator: this._comparisonOperator,
            datapoints_to_alarm: this._datapointsToAlarm,
            dimensions: this._dimensions,
            evaluate_low_sample_count_percentiles: this._evaluateLowSampleCountPercentiles,
            evaluation_periods: this._evaluationPeriods,
            extended_statistic: this._extendedStatistic,
            insufficient_data_actions: this._insufficientDataActions,
            metric_name: this._metricName,
            namespace: this._namespace,
            ok_actions: this._okActions,
            period: this._period,
            statistic: this._statistic,
            tags: this._tags,
            threshold: this._threshold,
            threshold_metric_id: this._thresholdMetricId,
            treat_missing_data: this._treatMissingData,
            unit: this._unit,
            metric_query: this._metricQuery,
        };
    }
}
exports.CloudwatchMetricAlarm = CloudwatchMetricAlarm;
//# sourceMappingURL=data:application/json;base64,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