import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CodebuildProjectConfig extends TerraformMetaArguments {
    readonly badgeEnabled?: boolean;
    readonly buildTimeout?: number;
    readonly description?: string;
    readonly encryptionKey?: string;
    readonly name: string;
    readonly queuedTimeout?: number;
    readonly serviceRole: string;
    readonly sourceVersion?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** artifacts block */
    readonly artifacts: CodebuildProjectArtifacts[];
    /** cache block */
    readonly cache?: CodebuildProjectCache[];
    /** environment block */
    readonly environment: CodebuildProjectEnvironment[];
    /** logs_config block */
    readonly logsConfig?: CodebuildProjectLogsConfig[];
    /** secondary_artifacts block */
    readonly secondaryArtifacts?: CodebuildProjectSecondaryArtifacts[];
    /** secondary_sources block */
    readonly secondarySources?: CodebuildProjectSecondarySources[];
    /** source block */
    readonly source: CodebuildProjectSource[];
    /** vpc_config block */
    readonly vpcConfig?: CodebuildProjectVpcConfig[];
}
export interface CodebuildProjectArtifacts {
    readonly artifactIdentifier?: string;
    readonly encryptionDisabled?: boolean;
    readonly location?: string;
    readonly name?: string;
    readonly namespaceType?: string;
    readonly overrideArtifactName?: boolean;
    readonly packaging?: string;
    readonly path?: string;
    readonly type: string;
}
export interface CodebuildProjectCache {
    readonly location?: string;
    readonly modes?: string[];
    readonly type?: string;
}
export interface CodebuildProjectEnvironmentEnvironmentVariable {
    readonly name: string;
    readonly type?: string;
    readonly value: string;
}
export interface CodebuildProjectEnvironmentRegistryCredential {
    readonly credential: string;
    readonly credentialProvider: string;
}
export interface CodebuildProjectEnvironment {
    readonly certificate?: string;
    readonly computeType: string;
    readonly image: string;
    readonly imagePullCredentialsType?: string;
    readonly privilegedMode?: boolean;
    readonly type: string;
    /** environment_variable block */
    readonly environmentVariable?: CodebuildProjectEnvironmentEnvironmentVariable[];
    /** registry_credential block */
    readonly registryCredential?: CodebuildProjectEnvironmentRegistryCredential[];
}
export interface CodebuildProjectLogsConfigCloudwatchLogs {
    readonly groupName?: string;
    readonly status?: string;
    readonly streamName?: string;
}
export interface CodebuildProjectLogsConfigS3Logs {
    readonly encryptionDisabled?: boolean;
    readonly location?: string;
    readonly status?: string;
}
export interface CodebuildProjectLogsConfig {
    /** cloudwatch_logs block */
    readonly cloudwatchLogs?: CodebuildProjectLogsConfigCloudwatchLogs[];
    /** s3_logs block */
    readonly s3Logs?: CodebuildProjectLogsConfigS3Logs[];
}
export interface CodebuildProjectSecondaryArtifacts {
    readonly artifactIdentifier: string;
    readonly encryptionDisabled?: boolean;
    readonly location?: string;
    readonly name?: string;
    readonly namespaceType?: string;
    readonly overrideArtifactName?: boolean;
    readonly packaging?: string;
    readonly path?: string;
    readonly type: string;
}
export interface CodebuildProjectSecondarySourcesAuth {
    readonly resource?: string;
    readonly type: string;
}
export interface CodebuildProjectSecondarySourcesGitSubmodulesConfig {
    readonly fetchSubmodules: boolean;
}
export interface CodebuildProjectSecondarySources {
    readonly buildspec?: string;
    readonly gitCloneDepth?: number;
    readonly insecureSsl?: boolean;
    readonly location?: string;
    readonly reportBuildStatus?: boolean;
    readonly sourceIdentifier: string;
    readonly type: string;
    /** auth block */
    readonly auth?: CodebuildProjectSecondarySourcesAuth[];
    /** git_submodules_config block */
    readonly gitSubmodulesConfig?: CodebuildProjectSecondarySourcesGitSubmodulesConfig[];
}
export interface CodebuildProjectSourceAuth {
    readonly resource?: string;
    readonly type: string;
}
export interface CodebuildProjectSourceGitSubmodulesConfig {
    readonly fetchSubmodules: boolean;
}
export interface CodebuildProjectSource {
    readonly buildspec?: string;
    readonly gitCloneDepth?: number;
    readonly insecureSsl?: boolean;
    readonly location?: string;
    readonly reportBuildStatus?: boolean;
    readonly type: string;
    /** auth block */
    readonly auth?: CodebuildProjectSourceAuth[];
    /** git_submodules_config block */
    readonly gitSubmodulesConfig?: CodebuildProjectSourceGitSubmodulesConfig[];
}
export interface CodebuildProjectVpcConfig {
    readonly securityGroupIds: string[];
    readonly subnets: string[];
    readonly vpcId: string;
}
export declare class CodebuildProject extends TerraformResource {
    constructor(scope: Construct, id: string, config: CodebuildProjectConfig);
    get arn(): string;
    private _badgeEnabled?;
    get badgeEnabled(): boolean | undefined;
    set badgeEnabled(value: boolean | undefined);
    get badgeUrl(): string;
    private _buildTimeout?;
    get buildTimeout(): number | undefined;
    set buildTimeout(value: number | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _encryptionKey?;
    get encryptionKey(): string | undefined;
    set encryptionKey(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _queuedTimeout?;
    get queuedTimeout(): number | undefined;
    set queuedTimeout(value: number | undefined);
    private _serviceRole;
    get serviceRole(): string;
    set serviceRole(value: string);
    private _sourceVersion?;
    get sourceVersion(): string | undefined;
    set sourceVersion(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _artifacts;
    get artifacts(): CodebuildProjectArtifacts[];
    set artifacts(value: CodebuildProjectArtifacts[]);
    private _cache?;
    get cache(): CodebuildProjectCache[] | undefined;
    set cache(value: CodebuildProjectCache[] | undefined);
    private _environment;
    get environment(): CodebuildProjectEnvironment[];
    set environment(value: CodebuildProjectEnvironment[]);
    private _logsConfig?;
    get logsConfig(): CodebuildProjectLogsConfig[] | undefined;
    set logsConfig(value: CodebuildProjectLogsConfig[] | undefined);
    private _secondaryArtifacts?;
    get secondaryArtifacts(): CodebuildProjectSecondaryArtifacts[] | undefined;
    set secondaryArtifacts(value: CodebuildProjectSecondaryArtifacts[] | undefined);
    private _secondarySources?;
    get secondarySources(): CodebuildProjectSecondarySources[] | undefined;
    set secondarySources(value: CodebuildProjectSecondarySources[] | undefined);
    private _source;
    get source(): CodebuildProjectSource[];
    set source(value: CodebuildProjectSource[]);
    private _vpcConfig?;
    get vpcConfig(): CodebuildProjectVpcConfig[] | undefined;
    set vpcConfig(value: CodebuildProjectVpcConfig[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
