import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CodebuildWebhookConfig extends TerraformMetaArguments {
    readonly branchFilter?: string;
    readonly projectName: string;
    /** filter_group block */
    readonly filterGroup?: CodebuildWebhookFilterGroup[];
}
export interface CodebuildWebhookFilterGroupFilter {
    readonly excludeMatchedPattern?: boolean;
    readonly pattern: string;
    readonly type: string;
}
export interface CodebuildWebhookFilterGroup {
    /** filter block */
    readonly filter?: CodebuildWebhookFilterGroupFilter[];
}
export declare class CodebuildWebhook extends TerraformResource {
    constructor(scope: Construct, id: string, config: CodebuildWebhookConfig);
    private _branchFilter?;
    get branchFilter(): string | undefined;
    set branchFilter(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get payloadUrl(): string;
    private _projectName;
    get projectName(): string;
    set projectName(value: string);
    get secret(): string;
    get url(): string;
    private _filterGroup?;
    get filterGroup(): CodebuildWebhookFilterGroup[] | undefined;
    set filterGroup(value: CodebuildWebhookFilterGroup[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
