import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CodecommitRepositoryConfig extends TerraformMetaArguments {
    readonly defaultBranch?: string;
    readonly description?: string;
    readonly repositoryName: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class CodecommitRepository extends TerraformResource {
    constructor(scope: Construct, id: string, config: CodecommitRepositoryConfig);
    get arn(): string;
    get cloneUrlHttp(): string;
    get cloneUrlSsh(): string;
    private _defaultBranch?;
    get defaultBranch(): string | undefined;
    set defaultBranch(value: string | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get repositoryId(): string;
    private _repositoryName;
    get repositoryName(): string;
    set repositoryName(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
