import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CodecommitTriggerConfig extends TerraformMetaArguments {
    readonly repositoryName: string;
    /** trigger block */
    readonly trigger: CodecommitTriggerTrigger[];
}
export interface CodecommitTriggerTrigger {
    readonly branches?: string[];
    readonly customData?: string;
    readonly destinationArn: string;
    readonly events: string[];
    readonly name: string;
}
export declare class CodecommitTrigger extends TerraformResource {
    constructor(scope: Construct, id: string, config: CodecommitTriggerConfig);
    get configurationId(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _repositoryName;
    get repositoryName(): string;
    set repositoryName(value: string);
    private _trigger;
    get trigger(): CodecommitTriggerTrigger[];
    set trigger(value: CodecommitTriggerTrigger[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
