import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CodedeployDeploymentConfigConfig extends TerraformMetaArguments {
    readonly computePlatform?: string;
    readonly deploymentConfigName: string;
    /** minimum_healthy_hosts block */
    readonly minimumHealthyHosts?: CodedeployDeploymentConfigMinimumHealthyHosts[];
    /** traffic_routing_config block */
    readonly trafficRoutingConfig?: CodedeployDeploymentConfigTrafficRoutingConfig[];
}
export interface CodedeployDeploymentConfigMinimumHealthyHosts {
    readonly type?: string;
    readonly value?: number;
}
export interface CodedeployDeploymentConfigTrafficRoutingConfigTimeBasedCanary {
    readonly interval?: number;
    readonly percentage?: number;
}
export interface CodedeployDeploymentConfigTrafficRoutingConfigTimeBasedLinear {
    readonly interval?: number;
    readonly percentage?: number;
}
export interface CodedeployDeploymentConfigTrafficRoutingConfig {
    readonly type?: string;
    /** time_based_canary block */
    readonly timeBasedCanary?: CodedeployDeploymentConfigTrafficRoutingConfigTimeBasedCanary[];
    /** time_based_linear block */
    readonly timeBasedLinear?: CodedeployDeploymentConfigTrafficRoutingConfigTimeBasedLinear[];
}
export declare class CodedeployDeploymentConfig extends TerraformResource {
    constructor(scope: Construct, id: string, config: CodedeployDeploymentConfigConfig);
    private _computePlatform?;
    get computePlatform(): string | undefined;
    set computePlatform(value: string | undefined);
    get deploymentConfigId(): string;
    private _deploymentConfigName;
    get deploymentConfigName(): string;
    set deploymentConfigName(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _minimumHealthyHosts?;
    get minimumHealthyHosts(): CodedeployDeploymentConfigMinimumHealthyHosts[] | undefined;
    set minimumHealthyHosts(value: CodedeployDeploymentConfigMinimumHealthyHosts[] | undefined);
    private _trafficRoutingConfig?;
    get trafficRoutingConfig(): CodedeployDeploymentConfigTrafficRoutingConfig[] | undefined;
    set trafficRoutingConfig(value: CodedeployDeploymentConfigTrafficRoutingConfig[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
