"use strict";
// https://www.terraform.io/docs/providers/aws/r/codedeploy_deployment_config.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodedeployDeploymentConfig = void 0;
const cdktf_1 = require("cdktf");
// Resource
class CodedeployDeploymentConfig extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_codedeploy_deployment_config',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._computePlatform = config.computePlatform;
        this._deploymentConfigName = config.deploymentConfigName;
        this._minimumHealthyHosts = config.minimumHealthyHosts;
        this._trafficRoutingConfig = config.trafficRoutingConfig;
    }
    get computePlatform() {
        return this._computePlatform;
    }
    set computePlatform(value) {
        this._computePlatform = value;
    }
    // deployment_config_id - computed: true, optional: false, required: true
    get deploymentConfigId() {
        return this.getStringAttribute('deployment_config_id');
    }
    get deploymentConfigName() {
        return this._deploymentConfigName;
    }
    set deploymentConfigName(value) {
        this._deploymentConfigName = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get minimumHealthyHosts() {
        return this._minimumHealthyHosts;
    }
    set minimumHealthyHosts(value) {
        this._minimumHealthyHosts = value;
    }
    get trafficRoutingConfig() {
        return this._trafficRoutingConfig;
    }
    set trafficRoutingConfig(value) {
        this._trafficRoutingConfig = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            compute_platform: this._computePlatform,
            deployment_config_name: this._deploymentConfigName,
            minimum_healthy_hosts: this._minimumHealthyHosts,
            traffic_routing_config: this._trafficRoutingConfig,
        };
    }
}
exports.CodedeployDeploymentConfig = CodedeployDeploymentConfig;
//# sourceMappingURL=data:application/json;base64,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