import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CodedeployDeploymentGroupConfig extends TerraformMetaArguments {
    readonly appName: string;
    readonly autoscalingGroups?: string[];
    readonly deploymentConfigName?: string;
    readonly deploymentGroupName: string;
    readonly serviceRoleArn: string;
    /** alarm_configuration block */
    readonly alarmConfiguration?: CodedeployDeploymentGroupAlarmConfiguration[];
    /** auto_rollback_configuration block */
    readonly autoRollbackConfiguration?: CodedeployDeploymentGroupAutoRollbackConfiguration[];
    /** blue_green_deployment_config block */
    readonly blueGreenDeploymentConfig?: CodedeployDeploymentGroupBlueGreenDeploymentConfig[];
    /** deployment_style block */
    readonly deploymentStyle?: CodedeployDeploymentGroupDeploymentStyle[];
    /** ec2_tag_filter block */
    readonly ec2TagFilter?: CodedeployDeploymentGroupEc2TagFilter[];
    /** ec2_tag_set block */
    readonly ec2TagSet?: CodedeployDeploymentGroupEc2TagSet[];
    /** ecs_service block */
    readonly ecsService?: CodedeployDeploymentGroupEcsService[];
    /** load_balancer_info block */
    readonly loadBalancerInfo?: CodedeployDeploymentGroupLoadBalancerInfo[];
    /** on_premises_instance_tag_filter block */
    readonly onPremisesInstanceTagFilter?: CodedeployDeploymentGroupOnPremisesInstanceTagFilter[];
    /** trigger_configuration block */
    readonly triggerConfiguration?: CodedeployDeploymentGroupTriggerConfiguration[];
}
export interface CodedeployDeploymentGroupAlarmConfiguration {
    readonly alarms?: string[];
    readonly enabled?: boolean;
    readonly ignorePollAlarmFailure?: boolean;
}
export interface CodedeployDeploymentGroupAutoRollbackConfiguration {
    readonly enabled?: boolean;
    readonly events?: string[];
}
export interface CodedeployDeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOption {
    readonly actionOnTimeout?: string;
    readonly waitTimeInMinutes?: number;
}
export interface CodedeployDeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOption {
    readonly action?: string;
}
export interface CodedeployDeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccess {
    readonly action?: string;
    readonly terminationWaitTimeInMinutes?: number;
}
export interface CodedeployDeploymentGroupBlueGreenDeploymentConfig {
    /** deployment_ready_option block */
    readonly deploymentReadyOption?: CodedeployDeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOption[];
    /** green_fleet_provisioning_option block */
    readonly greenFleetProvisioningOption?: CodedeployDeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOption[];
    /** terminate_blue_instances_on_deployment_success block */
    readonly terminateBlueInstancesOnDeploymentSuccess?: CodedeployDeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccess[];
}
export interface CodedeployDeploymentGroupDeploymentStyle {
    readonly deploymentOption?: string;
    readonly deploymentType?: string;
}
export interface CodedeployDeploymentGroupEc2TagFilter {
    readonly key?: string;
    readonly type?: string;
    readonly value?: string;
}
export interface CodedeployDeploymentGroupEc2TagSetEc2TagFilter {
    readonly key?: string;
    readonly type?: string;
    readonly value?: string;
}
export interface CodedeployDeploymentGroupEc2TagSet {
    /** ec2_tag_filter block */
    readonly ec2TagFilter?: CodedeployDeploymentGroupEc2TagSetEc2TagFilter[];
}
export interface CodedeployDeploymentGroupEcsService {
    readonly clusterName: string;
    readonly serviceName: string;
}
export interface CodedeployDeploymentGroupLoadBalancerInfoElbInfo {
    readonly name?: string;
}
export interface CodedeployDeploymentGroupLoadBalancerInfoTargetGroupInfo {
    readonly name?: string;
}
export interface CodedeployDeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRoute {
    readonly listenerArns: string[];
}
export interface CodedeployDeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroup {
    readonly name: string;
}
export interface CodedeployDeploymentGroupLoadBalancerInfoTargetGroupPairInfoTestTrafficRoute {
    readonly listenerArns: string[];
}
export interface CodedeployDeploymentGroupLoadBalancerInfoTargetGroupPairInfo {
    /** prod_traffic_route block */
    readonly prodTrafficRoute: CodedeployDeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRoute[];
    /** target_group block */
    readonly targetGroup: CodedeployDeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroup[];
    /** test_traffic_route block */
    readonly testTrafficRoute?: CodedeployDeploymentGroupLoadBalancerInfoTargetGroupPairInfoTestTrafficRoute[];
}
export interface CodedeployDeploymentGroupLoadBalancerInfo {
    /** elb_info block */
    readonly elbInfo?: CodedeployDeploymentGroupLoadBalancerInfoElbInfo[];
    /** target_group_info block */
    readonly targetGroupInfo?: CodedeployDeploymentGroupLoadBalancerInfoTargetGroupInfo[];
    /** target_group_pair_info block */
    readonly targetGroupPairInfo?: CodedeployDeploymentGroupLoadBalancerInfoTargetGroupPairInfo[];
}
export interface CodedeployDeploymentGroupOnPremisesInstanceTagFilter {
    readonly key?: string;
    readonly type?: string;
    readonly value?: string;
}
export interface CodedeployDeploymentGroupTriggerConfiguration {
    readonly triggerEvents: string[];
    readonly triggerName: string;
    readonly triggerTargetArn: string;
}
export declare class CodedeployDeploymentGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: CodedeployDeploymentGroupConfig);
    private _appName;
    get appName(): string;
    set appName(value: string);
    private _autoscalingGroups?;
    get autoscalingGroups(): string[] | undefined;
    set autoscalingGroups(value: string[] | undefined);
    private _deploymentConfigName?;
    get deploymentConfigName(): string | undefined;
    set deploymentConfigName(value: string | undefined);
    private _deploymentGroupName;
    get deploymentGroupName(): string;
    set deploymentGroupName(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _serviceRoleArn;
    get serviceRoleArn(): string;
    set serviceRoleArn(value: string);
    private _alarmConfiguration?;
    get alarmConfiguration(): CodedeployDeploymentGroupAlarmConfiguration[] | undefined;
    set alarmConfiguration(value: CodedeployDeploymentGroupAlarmConfiguration[] | undefined);
    private _autoRollbackConfiguration?;
    get autoRollbackConfiguration(): CodedeployDeploymentGroupAutoRollbackConfiguration[] | undefined;
    set autoRollbackConfiguration(value: CodedeployDeploymentGroupAutoRollbackConfiguration[] | undefined);
    private _blueGreenDeploymentConfig?;
    get blueGreenDeploymentConfig(): CodedeployDeploymentGroupBlueGreenDeploymentConfig[] | undefined;
    set blueGreenDeploymentConfig(value: CodedeployDeploymentGroupBlueGreenDeploymentConfig[] | undefined);
    private _deploymentStyle?;
    get deploymentStyle(): CodedeployDeploymentGroupDeploymentStyle[] | undefined;
    set deploymentStyle(value: CodedeployDeploymentGroupDeploymentStyle[] | undefined);
    private _ec2TagFilter?;
    get ec2TagFilter(): CodedeployDeploymentGroupEc2TagFilter[] | undefined;
    set ec2TagFilter(value: CodedeployDeploymentGroupEc2TagFilter[] | undefined);
    private _ec2TagSet?;
    get ec2TagSet(): CodedeployDeploymentGroupEc2TagSet[] | undefined;
    set ec2TagSet(value: CodedeployDeploymentGroupEc2TagSet[] | undefined);
    private _ecsService?;
    get ecsService(): CodedeployDeploymentGroupEcsService[] | undefined;
    set ecsService(value: CodedeployDeploymentGroupEcsService[] | undefined);
    private _loadBalancerInfo?;
    get loadBalancerInfo(): CodedeployDeploymentGroupLoadBalancerInfo[] | undefined;
    set loadBalancerInfo(value: CodedeployDeploymentGroupLoadBalancerInfo[] | undefined);
    private _onPremisesInstanceTagFilter?;
    get onPremisesInstanceTagFilter(): CodedeployDeploymentGroupOnPremisesInstanceTagFilter[] | undefined;
    set onPremisesInstanceTagFilter(value: CodedeployDeploymentGroupOnPremisesInstanceTagFilter[] | undefined);
    private _triggerConfiguration?;
    get triggerConfiguration(): CodedeployDeploymentGroupTriggerConfiguration[] | undefined;
    set triggerConfiguration(value: CodedeployDeploymentGroupTriggerConfiguration[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
