"use strict";
// https://www.terraform.io/docs/providers/aws/r/codedeploy_deployment_group.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodedeployDeploymentGroup = void 0;
const cdktf_1 = require("cdktf");
// Resource
class CodedeployDeploymentGroup extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_codedeploy_deployment_group',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._appName = config.appName;
        this._autoscalingGroups = config.autoscalingGroups;
        this._deploymentConfigName = config.deploymentConfigName;
        this._deploymentGroupName = config.deploymentGroupName;
        this._serviceRoleArn = config.serviceRoleArn;
        this._alarmConfiguration = config.alarmConfiguration;
        this._autoRollbackConfiguration = config.autoRollbackConfiguration;
        this._blueGreenDeploymentConfig = config.blueGreenDeploymentConfig;
        this._deploymentStyle = config.deploymentStyle;
        this._ec2TagFilter = config.ec2TagFilter;
        this._ec2TagSet = config.ec2TagSet;
        this._ecsService = config.ecsService;
        this._loadBalancerInfo = config.loadBalancerInfo;
        this._onPremisesInstanceTagFilter = config.onPremisesInstanceTagFilter;
        this._triggerConfiguration = config.triggerConfiguration;
    }
    get appName() {
        return this._appName;
    }
    set appName(value) {
        this._appName = value;
    }
    get autoscalingGroups() {
        return this._autoscalingGroups;
    }
    set autoscalingGroups(value) {
        this._autoscalingGroups = value;
    }
    get deploymentConfigName() {
        return this._deploymentConfigName;
    }
    set deploymentConfigName(value) {
        this._deploymentConfigName = value;
    }
    get deploymentGroupName() {
        return this._deploymentGroupName;
    }
    set deploymentGroupName(value) {
        this._deploymentGroupName = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get serviceRoleArn() {
        return this._serviceRoleArn;
    }
    set serviceRoleArn(value) {
        this._serviceRoleArn = value;
    }
    get alarmConfiguration() {
        return this._alarmConfiguration;
    }
    set alarmConfiguration(value) {
        this._alarmConfiguration = value;
    }
    get autoRollbackConfiguration() {
        return this._autoRollbackConfiguration;
    }
    set autoRollbackConfiguration(value) {
        this._autoRollbackConfiguration = value;
    }
    get blueGreenDeploymentConfig() {
        return this._blueGreenDeploymentConfig;
    }
    set blueGreenDeploymentConfig(value) {
        this._blueGreenDeploymentConfig = value;
    }
    get deploymentStyle() {
        return this._deploymentStyle;
    }
    set deploymentStyle(value) {
        this._deploymentStyle = value;
    }
    get ec2TagFilter() {
        return this._ec2TagFilter;
    }
    set ec2TagFilter(value) {
        this._ec2TagFilter = value;
    }
    get ec2TagSet() {
        return this._ec2TagSet;
    }
    set ec2TagSet(value) {
        this._ec2TagSet = value;
    }
    get ecsService() {
        return this._ecsService;
    }
    set ecsService(value) {
        this._ecsService = value;
    }
    get loadBalancerInfo() {
        return this._loadBalancerInfo;
    }
    set loadBalancerInfo(value) {
        this._loadBalancerInfo = value;
    }
    get onPremisesInstanceTagFilter() {
        return this._onPremisesInstanceTagFilter;
    }
    set onPremisesInstanceTagFilter(value) {
        this._onPremisesInstanceTagFilter = value;
    }
    get triggerConfiguration() {
        return this._triggerConfiguration;
    }
    set triggerConfiguration(value) {
        this._triggerConfiguration = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            app_name: this._appName,
            autoscaling_groups: this._autoscalingGroups,
            deployment_config_name: this._deploymentConfigName,
            deployment_group_name: this._deploymentGroupName,
            service_role_arn: this._serviceRoleArn,
            alarm_configuration: this._alarmConfiguration,
            auto_rollback_configuration: this._autoRollbackConfiguration,
            blue_green_deployment_config: this._blueGreenDeploymentConfig,
            deployment_style: this._deploymentStyle,
            ec2_tag_filter: this._ec2TagFilter,
            ec2_tag_set: this._ec2TagSet,
            ecs_service: this._ecsService,
            load_balancer_info: this._loadBalancerInfo,
            on_premises_instance_tag_filter: this._onPremisesInstanceTagFilter,
            trigger_configuration: this._triggerConfiguration,
        };
    }
}
exports.CodedeployDeploymentGroup = CodedeployDeploymentGroup;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29kZWRlcGxveS1kZXBsb3ltZW50LWdyb3VwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2NvZGVkZXBsb3ktZGVwbG95bWVudC1ncm91cC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsaUZBQWlGO0FBQ2pGLDJDQUEyQzs7O0FBZ1YzQyxpQ0FBMEM7QUE0SDFDLFdBQVc7QUFFWCxNQUFhLHlCQUEwQixTQUFRLHlCQUFpQjtJQUU5RCxjQUFjO0lBQ2QsY0FBYztJQUNkLGNBQWM7SUFFZCxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxNQUF1QztRQUN0RixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLHFCQUFxQixFQUFFLGlDQUFpQztZQUN4RCwwQkFBMEIsRUFBRTtnQkFDMUIsWUFBWSxFQUFFLEtBQUs7YUFDcEI7WUFDRCxRQUFRLEVBQUUsTUFBTSxDQUFDLFFBQVE7WUFDekIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1lBQzNCLEtBQUssRUFBRSxNQUFNLENBQUMsS0FBSztZQUNuQixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7U0FDNUIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDO1FBQy9CLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxNQUFNLENBQUMsaUJBQWlCLENBQUM7UUFDbkQsSUFBSSxDQUFDLHFCQUFxQixHQUFHLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQztRQUN6RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsTUFBTSxDQUFDLG1CQUFtQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUM3QyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsTUFBTSxDQUFDLGtCQUFrQixDQUFDO1FBQ3JELElBQUksQ0FBQywwQkFBMEIsR0FBRyxNQUFNLENBQUMseUJBQXlCLENBQUM7UUFDbkUsSUFBSSxDQUFDLDBCQUEwQixHQUFHLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQztRQUNuRSxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsTUFBTSxDQUFDLGVBQWUsQ0FBQztRQUMvQyxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxZQUFZLENBQUM7UUFDekMsSUFBSSxDQUFDLFVBQVUsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO1FBQ25DLElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pELElBQUksQ0FBQyw0QkFBNEIsR0FBRyxNQUFNLENBQUMsMkJBQTJCLENBQUM7UUFDdkUsSUFBSSxDQUFDLHFCQUFxQixHQUFHLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQztJQUMzRCxDQUFDO0lBUUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBYTtRQUM5QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUNELElBQVcsaUJBQWlCLENBQUMsS0FBMkI7UUFDdEQsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDO0lBSUQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMscUJBQXFCLENBQUM7SUFDcEMsQ0FBQztJQUNELElBQVcsb0JBQW9CLENBQUMsS0FBeUI7UUFDdkQsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQztJQUNyQyxDQUFDO0lBSUQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsb0JBQW9CLENBQUM7SUFDbkMsQ0FBQztJQUNELElBQVcsbUJBQW1CLENBQUMsS0FBYTtRQUMxQyxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDO0lBQ3BDLENBQUM7SUFJRCxJQUFXLEVBQUU7O1FBQ1gsYUFBTyxJQUFJLENBQUMsR0FBRyxtQ0FBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQXlCO1FBQ3JDLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDO0lBQ25CLENBQUM7SUFJRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFDRCxJQUFXLGNBQWMsQ0FBQyxLQUFhO1FBQ3JDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO0lBQy9CLENBQUM7SUFJRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztJQUNsQyxDQUFDO0lBQ0QsSUFBVyxrQkFBa0IsQ0FBQyxLQUFnRTtRQUM1RixJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO0lBQ25DLENBQUM7SUFJRCxJQUFXLHlCQUF5QjtRQUNsQyxPQUFPLElBQUksQ0FBQywwQkFBMEIsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyx5QkFBeUIsQ0FBQyxLQUF1RTtRQUMxRyxJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDO0lBQzFDLENBQUM7SUFJRCxJQUFXLHlCQUF5QjtRQUNsQyxPQUFPLElBQUksQ0FBQywwQkFBMEIsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyx5QkFBeUIsQ0FBQyxLQUF1RTtRQUMxRyxJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDO0lBQzFDLENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQTZEO1FBQ3RGLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUM7SUFDaEMsQ0FBQztJQUlELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQUNELElBQVcsWUFBWSxDQUFDLEtBQTBEO1FBQ2hGLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFDRCxJQUFXLFNBQVMsQ0FBQyxLQUF1RDtRQUMxRSxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBd0Q7UUFDNUUsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFDRCxJQUFXLGdCQUFnQixDQUFDLEtBQThEO1FBQ3hGLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7SUFDakMsQ0FBQztJQUlELElBQVcsMkJBQTJCO1FBQ3BDLE9BQU8sSUFBSSxDQUFDLDRCQUE0QixDQUFDO0lBQzNDLENBQUM7SUFDRCxJQUFXLDJCQUEyQixDQUFDLEtBQXlFO1FBQzlHLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxLQUFLLENBQUM7SUFDNUMsQ0FBQztJQUlELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLHFCQUFxQixDQUFDO0lBQ3BDLENBQUM7SUFDRCxJQUFXLG9CQUFvQixDQUFDLEtBQWtFO1FBQ2hHLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUM7SUFDckMsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVMLG9CQUFvQjtRQUN6QixPQUFPO1lBQ0wsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLGtCQUFrQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDM0Msc0JBQXNCLEVBQUUsSUFBSSxDQUFDLHFCQUFxQjtZQUNsRCxxQkFBcUIsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1lBQ2hELGdCQUFnQixFQUFFLElBQUksQ0FBQyxlQUFlO1lBQ3RDLG1CQUFtQixFQUFFLElBQUksQ0FBQyxtQkFBbUI7WUFDN0MsMkJBQTJCLEVBQUUsSUFBSSxDQUFDLDBCQUEwQjtZQUM1RCw0QkFBNEIsRUFBRSxJQUFJLENBQUMsMEJBQTBCO1lBQzdELGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDdkMsY0FBYyxFQUFFLElBQUksQ0FBQyxhQUFhO1lBQ2xDLFdBQVcsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUM1QixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0Isa0JBQWtCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUMxQywrQkFBK0IsRUFBRSxJQUFJLENBQUMsNEJBQTRCO1lBQ2xFLHFCQUFxQixFQUFFLElBQUksQ0FBQyxxQkFBcUI7U0FDbEQsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQTdNRCw4REE2TUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXdzL3IvY29kZWRlcGxveV9kZXBsb3ltZW50X2dyb3VwLmh0bWxcbi8vIGdlbmVyYXRlZCBmcm9tIHRlcnJhZm9ybSByZXNvdXJjZSBzY2hlbWFcblxuLypcbntcbiAgXCJ2ZXJzaW9uXCI6IDAsXG4gIFwiYmxvY2tcIjoge1xuICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICBcImFwcF9uYW1lXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiYXV0b3NjYWxpbmdfZ3JvdXBzXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFtcbiAgICAgICAgICBcInNldFwiLFxuICAgICAgICAgIFwic3RyaW5nXCJcbiAgICAgICAgXSxcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJkZXBsb3ltZW50X2NvbmZpZ19uYW1lXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiZGVwbG95bWVudF9ncm91cF9uYW1lXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiaWRcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInNlcnZpY2Vfcm9sZV9hcm5cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICB9XG4gICAgfSxcbiAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgIFwiYWxhcm1fY29uZmlndXJhdGlvblwiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJhbGFybXNcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogW1xuICAgICAgICAgICAgICAgIFwic2V0XCIsXG4gICAgICAgICAgICAgICAgXCJzdHJpbmdcIlxuICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcImVuYWJsZWRcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJib29sXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiaWdub3JlX3BvbGxfYWxhcm1fZmFpbHVyZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcImJvb2xcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9LFxuICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICB9LFxuICAgICAgXCJhdXRvX3JvbGxiYWNrX2NvbmZpZ3VyYXRpb25cIjoge1xuICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgIFwiZW5hYmxlZFwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcImJvb2xcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJldmVudHNcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogW1xuICAgICAgICAgICAgICAgIFwic2V0XCIsXG4gICAgICAgICAgICAgICAgXCJzdHJpbmdcIlxuICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgIH0sXG4gICAgICBcImJsdWVfZ3JlZW5fZGVwbG95bWVudF9jb25maWdcIjoge1xuICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgXCJibG9ja190eXBlc1wiOiB7XG4gICAgICAgICAgICBcImRlcGxveW1lbnRfcmVhZHlfb3B0aW9uXCI6IHtcbiAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICBcImFjdGlvbl9vbl90aW1lb3V0XCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwid2FpdF90aW1lX2luX21pbnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJudW1iZXJcIixcbiAgICAgICAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJncmVlbl9mbGVldF9wcm92aXNpb25pbmdfb3B0aW9uXCI6IHtcbiAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICBcImFjdGlvblwiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInRlcm1pbmF0ZV9ibHVlX2luc3RhbmNlc19vbl9kZXBsb3ltZW50X3N1Y2Nlc3NcIjoge1xuICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgIFwiYWN0aW9uXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwidGVybWluYXRpb25fd2FpdF90aW1lX2luX21pbnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJudW1iZXJcIixcbiAgICAgICAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9LFxuICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICB9LFxuICAgICAgXCJkZXBsb3ltZW50X3N0eWxlXCI6IHtcbiAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICBcImRlcGxveW1lbnRfb3B0aW9uXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiZGVwbG95bWVudF90eXBlXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICAgICAgXCJtYXhfaXRlbXNcIjogMVxuICAgICAgfSxcbiAgICAgIFwiZWMyX3RhZ19maWx0ZXJcIjoge1xuICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcInNldFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJrZXlcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJ0eXBlXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwidmFsdWVcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9LFxuICAgICAgXCJlYzJfdGFnX3NldFwiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwic2V0XCIsXG4gICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgIFwiYmxvY2tfdHlwZXNcIjoge1xuICAgICAgICAgICAgXCJlYzJfdGFnX2ZpbHRlclwiOiB7XG4gICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwic2V0XCIsXG4gICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICBcImtleVwiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICBcInR5cGVcIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgXCJ2YWx1ZVwiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH0sXG4gICAgICBcImVjc19zZXJ2aWNlXCI6IHtcbiAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICBcImNsdXN0ZXJfbmFtZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInNlcnZpY2VfbmFtZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgIH0sXG4gICAgICBcImxvYWRfYmFsYW5jZXJfaW5mb1wiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgICAgICAgIFwiZWxiX2luZm9cIjoge1xuICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcInNldFwiLFxuICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgXCJuYW1lXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwidGFyZ2V0X2dyb3VwX2luZm9cIjoge1xuICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcInNldFwiLFxuICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgXCJuYW1lXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwidGFyZ2V0X2dyb3VwX3BhaXJfaW5mb1wiOiB7XG4gICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgIFwicHJvZF90cmFmZmljX3JvdXRlXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBcImxpc3RlbmVyX2FybnNcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogW1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwic2V0XCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJzdHJpbmdcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIFwibWluX2l0ZW1zXCI6IDEsXG4gICAgICAgICAgICAgICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICBcInRhcmdldF9ncm91cFwiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgXCJuYW1lXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgXCJtaW5faXRlbXNcIjogMSxcbiAgICAgICAgICAgICAgICAgICAgXCJtYXhfaXRlbXNcIjogMlxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwidGVzdF90cmFmZmljX3JvdXRlXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBcImxpc3RlbmVyX2FybnNcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogW1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwic2V0XCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJzdHJpbmdcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgIH0sXG4gICAgICBcIm9uX3ByZW1pc2VzX2luc3RhbmNlX3RhZ19maWx0ZXJcIjoge1xuICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcInNldFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJrZXlcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJ0eXBlXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwidmFsdWVcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9LFxuICAgICAgXCJ0cmlnZ2VyX2NvbmZpZ3VyYXRpb25cIjoge1xuICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcInNldFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJ0cmlnZ2VyX2V2ZW50c1wiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBbXG4gICAgICAgICAgICAgICAgXCJzZXRcIixcbiAgICAgICAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwidHJpZ2dlcl9uYW1lXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwidHJpZ2dlcl90YXJnZXRfYXJuXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cbiAgfVxufVxuKi9cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgVGVycmFmb3JtUmVzb3VyY2UgfSBmcm9tICdjZGt0Zic7XG5pbXBvcnQgeyBUZXJyYWZvcm1NZXRhQXJndW1lbnRzIH0gZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZWRlcGxveURlcGxveW1lbnRHcm91cENvbmZpZyBleHRlbmRzIFRlcnJhZm9ybU1ldGFBcmd1bWVudHMge1xuICByZWFkb25seSBhcHBOYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGF1dG9zY2FsaW5nR3JvdXBzPzogc3RyaW5nW107XG4gIHJlYWRvbmx5IGRlcGxveW1lbnRDb25maWdOYW1lPzogc3RyaW5nO1xuICByZWFkb25seSBkZXBsb3ltZW50R3JvdXBOYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNlcnZpY2VSb2xlQXJuOiBzdHJpbmc7XG4gIC8qKiBhbGFybV9jb25maWd1cmF0aW9uIGJsb2NrICovXG4gIHJlYWRvbmx5IGFsYXJtQ29uZmlndXJhdGlvbj86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBBbGFybUNvbmZpZ3VyYXRpb25bXTtcbiAgLyoqIGF1dG9fcm9sbGJhY2tfY29uZmlndXJhdGlvbiBibG9jayAqL1xuICByZWFkb25seSBhdXRvUm9sbGJhY2tDb25maWd1cmF0aW9uPzogQ29kZWRlcGxveURlcGxveW1lbnRHcm91cEF1dG9Sb2xsYmFja0NvbmZpZ3VyYXRpb25bXTtcbiAgLyoqIGJsdWVfZ3JlZW5fZGVwbG95bWVudF9jb25maWcgYmxvY2sgKi9cbiAgcmVhZG9ubHkgYmx1ZUdyZWVuRGVwbG95bWVudENvbmZpZz86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBCbHVlR3JlZW5EZXBsb3ltZW50Q29uZmlnW107XG4gIC8qKiBkZXBsb3ltZW50X3N0eWxlIGJsb2NrICovXG4gIHJlYWRvbmx5IGRlcGxveW1lbnRTdHlsZT86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBEZXBsb3ltZW50U3R5bGVbXTtcbiAgLyoqIGVjMl90YWdfZmlsdGVyIGJsb2NrICovXG4gIHJlYWRvbmx5IGVjMlRhZ0ZpbHRlcj86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBFYzJUYWdGaWx0ZXJbXTtcbiAgLyoqIGVjMl90YWdfc2V0IGJsb2NrICovXG4gIHJlYWRvbmx5IGVjMlRhZ1NldD86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBFYzJUYWdTZXRbXTtcbiAgLyoqIGVjc19zZXJ2aWNlIGJsb2NrICovXG4gIHJlYWRvbmx5IGVjc1NlcnZpY2U/OiBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwRWNzU2VydmljZVtdO1xuICAvKiogbG9hZF9iYWxhbmNlcl9pbmZvIGJsb2NrICovXG4gIHJlYWRvbmx5IGxvYWRCYWxhbmNlckluZm8/OiBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwTG9hZEJhbGFuY2VySW5mb1tdO1xuICAvKiogb25fcHJlbWlzZXNfaW5zdGFuY2VfdGFnX2ZpbHRlciBibG9jayAqL1xuICByZWFkb25seSBvblByZW1pc2VzSW5zdGFuY2VUYWdGaWx0ZXI/OiBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwT25QcmVtaXNlc0luc3RhbmNlVGFnRmlsdGVyW107XG4gIC8qKiB0cmlnZ2VyX2NvbmZpZ3VyYXRpb24gYmxvY2sgKi9cbiAgcmVhZG9ubHkgdHJpZ2dlckNvbmZpZ3VyYXRpb24/OiBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwVHJpZ2dlckNvbmZpZ3VyYXRpb25bXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZWRlcGxveURlcGxveW1lbnRHcm91cEFsYXJtQ29uZmlndXJhdGlvbiB7XG4gIHJlYWRvbmx5IGFsYXJtcz86IHN0cmluZ1tdO1xuICByZWFkb25seSBlbmFibGVkPzogYm9vbGVhbjtcbiAgcmVhZG9ubHkgaWdub3JlUG9sbEFsYXJtRmFpbHVyZT86IGJvb2xlYW47XG59XG5leHBvcnQgaW50ZXJmYWNlIENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBBdXRvUm9sbGJhY2tDb25maWd1cmF0aW9uIHtcbiAgcmVhZG9ubHkgZW5hYmxlZD86IGJvb2xlYW47XG4gIHJlYWRvbmx5IGV2ZW50cz86IHN0cmluZ1tdO1xufVxuZXhwb3J0IGludGVyZmFjZSBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwQmx1ZUdyZWVuRGVwbG95bWVudENvbmZpZ0RlcGxveW1lbnRSZWFkeU9wdGlvbiB7XG4gIHJlYWRvbmx5IGFjdGlvbk9uVGltZW91dD86IHN0cmluZztcbiAgcmVhZG9ubHkgd2FpdFRpbWVJbk1pbnV0ZXM/OiBudW1iZXI7XG59XG5leHBvcnQgaW50ZXJmYWNlIENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBCbHVlR3JlZW5EZXBsb3ltZW50Q29uZmlnR3JlZW5GbGVldFByb3Zpc2lvbmluZ09wdGlvbiB7XG4gIHJlYWRvbmx5IGFjdGlvbj86IHN0cmluZztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZWRlcGxveURlcGxveW1lbnRHcm91cEJsdWVHcmVlbkRlcGxveW1lbnRDb25maWdUZXJtaW5hdGVCbHVlSW5zdGFuY2VzT25EZXBsb3ltZW50U3VjY2VzcyB7XG4gIHJlYWRvbmx5IGFjdGlvbj86IHN0cmluZztcbiAgcmVhZG9ubHkgdGVybWluYXRpb25XYWl0VGltZUluTWludXRlcz86IG51bWJlcjtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZWRlcGxveURlcGxveW1lbnRHcm91cEJsdWVHcmVlbkRlcGxveW1lbnRDb25maWcge1xuICAvKiogZGVwbG95bWVudF9yZWFkeV9vcHRpb24gYmxvY2sgKi9cbiAgcmVhZG9ubHkgZGVwbG95bWVudFJlYWR5T3B0aW9uPzogQ29kZWRlcGxveURlcGxveW1lbnRHcm91cEJsdWVHcmVlbkRlcGxveW1lbnRDb25maWdEZXBsb3ltZW50UmVhZHlPcHRpb25bXTtcbiAgLyoqIGdyZWVuX2ZsZWV0X3Byb3Zpc2lvbmluZ19vcHRpb24gYmxvY2sgKi9cbiAgcmVhZG9ubHkgZ3JlZW5GbGVldFByb3Zpc2lvbmluZ09wdGlvbj86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBCbHVlR3JlZW5EZXBsb3ltZW50Q29uZmlnR3JlZW5GbGVldFByb3Zpc2lvbmluZ09wdGlvbltdO1xuICAvKiogdGVybWluYXRlX2JsdWVfaW5zdGFuY2VzX29uX2RlcGxveW1lbnRfc3VjY2VzcyBibG9jayAqL1xuICByZWFkb25seSB0ZXJtaW5hdGVCbHVlSW5zdGFuY2VzT25EZXBsb3ltZW50U3VjY2Vzcz86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBCbHVlR3JlZW5EZXBsb3ltZW50Q29uZmlnVGVybWluYXRlQmx1ZUluc3RhbmNlc09uRGVwbG95bWVudFN1Y2Nlc3NbXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZWRlcGxveURlcGxveW1lbnRHcm91cERlcGxveW1lbnRTdHlsZSB7XG4gIHJlYWRvbmx5IGRlcGxveW1lbnRPcHRpb24/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlcGxveW1lbnRUeXBlPzogc3RyaW5nO1xufVxuZXhwb3J0IGludGVyZmFjZSBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwRWMyVGFnRmlsdGVyIHtcbiAgcmVhZG9ubHkga2V5Pzogc3RyaW5nO1xuICByZWFkb25seSB0eXBlPzogc3RyaW5nO1xuICByZWFkb25seSB2YWx1ZT86IHN0cmluZztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZWRlcGxveURlcGxveW1lbnRHcm91cEVjMlRhZ1NldEVjMlRhZ0ZpbHRlciB7XG4gIHJlYWRvbmx5IGtleT86IHN0cmluZztcbiAgcmVhZG9ubHkgdHlwZT86IHN0cmluZztcbiAgcmVhZG9ubHkgdmFsdWU/OiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBFYzJUYWdTZXQge1xuICAvKiogZWMyX3RhZ19maWx0ZXIgYmxvY2sgKi9cbiAgcmVhZG9ubHkgZWMyVGFnRmlsdGVyPzogQ29kZWRlcGxveURlcGxveW1lbnRHcm91cEVjMlRhZ1NldEVjMlRhZ0ZpbHRlcltdO1xufVxuZXhwb3J0IGludGVyZmFjZSBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwRWNzU2VydmljZSB7XG4gIHJlYWRvbmx5IGNsdXN0ZXJOYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNlcnZpY2VOYW1lOiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBMb2FkQmFsYW5jZXJJbmZvRWxiSW5mbyB7XG4gIHJlYWRvbmx5IG5hbWU/OiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBMb2FkQmFsYW5jZXJJbmZvVGFyZ2V0R3JvdXBJbmZvIHtcbiAgcmVhZG9ubHkgbmFtZT86IHN0cmluZztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZWRlcGxveURlcGxveW1lbnRHcm91cExvYWRCYWxhbmNlckluZm9UYXJnZXRHcm91cFBhaXJJbmZvUHJvZFRyYWZmaWNSb3V0ZSB7XG4gIHJlYWRvbmx5IGxpc3RlbmVyQXJuczogc3RyaW5nW107XG59XG5leHBvcnQgaW50ZXJmYWNlIENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBMb2FkQmFsYW5jZXJJbmZvVGFyZ2V0R3JvdXBQYWlySW5mb1RhcmdldEdyb3VwIHtcbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xufVxuZXhwb3J0IGludGVyZmFjZSBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwTG9hZEJhbGFuY2VySW5mb1RhcmdldEdyb3VwUGFpckluZm9UZXN0VHJhZmZpY1JvdXRlIHtcbiAgcmVhZG9ubHkgbGlzdGVuZXJBcm5zOiBzdHJpbmdbXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZWRlcGxveURlcGxveW1lbnRHcm91cExvYWRCYWxhbmNlckluZm9UYXJnZXRHcm91cFBhaXJJbmZvIHtcbiAgLyoqIHByb2RfdHJhZmZpY19yb3V0ZSBibG9jayAqL1xuICByZWFkb25seSBwcm9kVHJhZmZpY1JvdXRlOiBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwTG9hZEJhbGFuY2VySW5mb1RhcmdldEdyb3VwUGFpckluZm9Qcm9kVHJhZmZpY1JvdXRlW107XG4gIC8qKiB0YXJnZXRfZ3JvdXAgYmxvY2sgKi9cbiAgcmVhZG9ubHkgdGFyZ2V0R3JvdXA6IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBMb2FkQmFsYW5jZXJJbmZvVGFyZ2V0R3JvdXBQYWlySW5mb1RhcmdldEdyb3VwW107XG4gIC8qKiB0ZXN0X3RyYWZmaWNfcm91dGUgYmxvY2sgKi9cbiAgcmVhZG9ubHkgdGVzdFRyYWZmaWNSb3V0ZT86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBMb2FkQmFsYW5jZXJJbmZvVGFyZ2V0R3JvdXBQYWlySW5mb1Rlc3RUcmFmZmljUm91dGVbXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZWRlcGxveURlcGxveW1lbnRHcm91cExvYWRCYWxhbmNlckluZm8ge1xuICAvKiogZWxiX2luZm8gYmxvY2sgKi9cbiAgcmVhZG9ubHkgZWxiSW5mbz86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBMb2FkQmFsYW5jZXJJbmZvRWxiSW5mb1tdO1xuICAvKiogdGFyZ2V0X2dyb3VwX2luZm8gYmxvY2sgKi9cbiAgcmVhZG9ubHkgdGFyZ2V0R3JvdXBJbmZvPzogQ29kZWRlcGxveURlcGxveW1lbnRHcm91cExvYWRCYWxhbmNlckluZm9UYXJnZXRHcm91cEluZm9bXTtcbiAgLyoqIHRhcmdldF9ncm91cF9wYWlyX2luZm8gYmxvY2sgKi9cbiAgcmVhZG9ubHkgdGFyZ2V0R3JvdXBQYWlySW5mbz86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBMb2FkQmFsYW5jZXJJbmZvVGFyZ2V0R3JvdXBQYWlySW5mb1tdO1xufVxuZXhwb3J0IGludGVyZmFjZSBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwT25QcmVtaXNlc0luc3RhbmNlVGFnRmlsdGVyIHtcbiAgcmVhZG9ubHkga2V5Pzogc3RyaW5nO1xuICByZWFkb25seSB0eXBlPzogc3RyaW5nO1xuICByZWFkb25seSB2YWx1ZT86IHN0cmluZztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZWRlcGxveURlcGxveW1lbnRHcm91cFRyaWdnZXJDb25maWd1cmF0aW9uIHtcbiAgcmVhZG9ubHkgdHJpZ2dlckV2ZW50czogc3RyaW5nW107XG4gIHJlYWRvbmx5IHRyaWdnZXJOYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHRyaWdnZXJUYXJnZXRBcm46IHN0cmluZztcbn1cblxuLy8gUmVzb3VyY2VcblxuZXhwb3J0IGNsYXNzIENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXAgZXh0ZW5kcyBUZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdhd3NfY29kZWRlcGxveV9kZXBsb3ltZW50X2dyb3VwJyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2F3cydcbiAgICAgIH0sXG4gICAgICBwcm92aWRlcjogY29uZmlnLnByb3ZpZGVyLFxuICAgICAgZGVwZW5kc09uOiBjb25maWcuZGVwZW5kc09uLFxuICAgICAgY291bnQ6IGNvbmZpZy5jb3VudCxcbiAgICAgIGxpZmVjeWNsZTogY29uZmlnLmxpZmVjeWNsZVxuICAgIH0pO1xuICAgIHRoaXMuX2FwcE5hbWUgPSBjb25maWcuYXBwTmFtZTtcbiAgICB0aGlzLl9hdXRvc2NhbGluZ0dyb3VwcyA9IGNvbmZpZy5hdXRvc2NhbGluZ0dyb3VwcztcbiAgICB0aGlzLl9kZXBsb3ltZW50Q29uZmlnTmFtZSA9IGNvbmZpZy5kZXBsb3ltZW50Q29uZmlnTmFtZTtcbiAgICB0aGlzLl9kZXBsb3ltZW50R3JvdXBOYW1lID0gY29uZmlnLmRlcGxveW1lbnRHcm91cE5hbWU7XG4gICAgdGhpcy5fc2VydmljZVJvbGVBcm4gPSBjb25maWcuc2VydmljZVJvbGVBcm47XG4gICAgdGhpcy5fYWxhcm1Db25maWd1cmF0aW9uID0gY29uZmlnLmFsYXJtQ29uZmlndXJhdGlvbjtcbiAgICB0aGlzLl9hdXRvUm9sbGJhY2tDb25maWd1cmF0aW9uID0gY29uZmlnLmF1dG9Sb2xsYmFja0NvbmZpZ3VyYXRpb247XG4gICAgdGhpcy5fYmx1ZUdyZWVuRGVwbG95bWVudENvbmZpZyA9IGNvbmZpZy5ibHVlR3JlZW5EZXBsb3ltZW50Q29uZmlnO1xuICAgIHRoaXMuX2RlcGxveW1lbnRTdHlsZSA9IGNvbmZpZy5kZXBsb3ltZW50U3R5bGU7XG4gICAgdGhpcy5fZWMyVGFnRmlsdGVyID0gY29uZmlnLmVjMlRhZ0ZpbHRlcjtcbiAgICB0aGlzLl9lYzJUYWdTZXQgPSBjb25maWcuZWMyVGFnU2V0O1xuICAgIHRoaXMuX2Vjc1NlcnZpY2UgPSBjb25maWcuZWNzU2VydmljZTtcbiAgICB0aGlzLl9sb2FkQmFsYW5jZXJJbmZvID0gY29uZmlnLmxvYWRCYWxhbmNlckluZm87XG4gICAgdGhpcy5fb25QcmVtaXNlc0luc3RhbmNlVGFnRmlsdGVyID0gY29uZmlnLm9uUHJlbWlzZXNJbnN0YW5jZVRhZ0ZpbHRlcjtcbiAgICB0aGlzLl90cmlnZ2VyQ29uZmlndXJhdGlvbiA9IGNvbmZpZy50cmlnZ2VyQ29uZmlndXJhdGlvbjtcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gYXBwX25hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfYXBwTmFtZTogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGFwcE5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FwcE5hbWU7XG4gIH1cbiAgcHVibGljIHNldCBhcHBOYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9hcHBOYW1lID0gdmFsdWU7XG4gIH1cblxuICAvLyBhdXRvc2NhbGluZ19ncm91cHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYXV0b3NjYWxpbmdHcm91cHM/OiBzdHJpbmdbXTtcbiAgcHVibGljIGdldCBhdXRvc2NhbGluZ0dyb3VwcygpIHtcbiAgICByZXR1cm4gdGhpcy5fYXV0b3NjYWxpbmdHcm91cHM7XG4gIH1cbiAgcHVibGljIHNldCBhdXRvc2NhbGluZ0dyb3Vwcyh2YWx1ZTogc3RyaW5nW10gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9hdXRvc2NhbGluZ0dyb3VwcyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gZGVwbG95bWVudF9jb25maWdfbmFtZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZXBsb3ltZW50Q29uZmlnTmFtZT86IHN0cmluZztcbiAgcHVibGljIGdldCBkZXBsb3ltZW50Q29uZmlnTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVwbG95bWVudENvbmZpZ05hbWU7XG4gIH1cbiAgcHVibGljIHNldCBkZXBsb3ltZW50Q29uZmlnTmFtZSh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fZGVwbG95bWVudENvbmZpZ05hbWUgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGRlcGxveW1lbnRfZ3JvdXBfbmFtZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9kZXBsb3ltZW50R3JvdXBOYW1lOiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgZGVwbG95bWVudEdyb3VwTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVwbG95bWVudEdyb3VwTmFtZTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlcGxveW1lbnRHcm91cE5hbWUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2RlcGxveW1lbnRHcm91cE5hbWUgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGlkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaWQ/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgaWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lkID8/IHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdpZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWQodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2lkID0gdmFsdWU7XG4gIH1cblxuICAvLyBzZXJ2aWNlX3JvbGVfYXJuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX3NlcnZpY2VSb2xlQXJuOiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgc2VydmljZVJvbGVBcm4oKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NlcnZpY2VSb2xlQXJuO1xuICB9XG4gIHB1YmxpYyBzZXQgc2VydmljZVJvbGVBcm4odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3NlcnZpY2VSb2xlQXJuID0gdmFsdWU7XG4gIH1cblxuICAvLyBhbGFybV9jb25maWd1cmF0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FsYXJtQ29uZmlndXJhdGlvbj86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBBbGFybUNvbmZpZ3VyYXRpb25bXTtcbiAgcHVibGljIGdldCBhbGFybUNvbmZpZ3VyYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FsYXJtQ29uZmlndXJhdGlvbjtcbiAgfVxuICBwdWJsaWMgc2V0IGFsYXJtQ29uZmlndXJhdGlvbih2YWx1ZTogQ29kZWRlcGxveURlcGxveW1lbnRHcm91cEFsYXJtQ29uZmlndXJhdGlvbltdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fYWxhcm1Db25maWd1cmF0aW9uID0gdmFsdWU7XG4gIH1cblxuICAvLyBhdXRvX3JvbGxiYWNrX2NvbmZpZ3VyYXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYXV0b1JvbGxiYWNrQ29uZmlndXJhdGlvbj86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBBdXRvUm9sbGJhY2tDb25maWd1cmF0aW9uW107XG4gIHB1YmxpYyBnZXQgYXV0b1JvbGxiYWNrQ29uZmlndXJhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5fYXV0b1JvbGxiYWNrQ29uZmlndXJhdGlvbjtcbiAgfVxuICBwdWJsaWMgc2V0IGF1dG9Sb2xsYmFja0NvbmZpZ3VyYXRpb24odmFsdWU6IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBBdXRvUm9sbGJhY2tDb25maWd1cmF0aW9uW10gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9hdXRvUm9sbGJhY2tDb25maWd1cmF0aW9uID0gdmFsdWU7XG4gIH1cblxuICAvLyBibHVlX2dyZWVuX2RlcGxveW1lbnRfY29uZmlnIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2JsdWVHcmVlbkRlcGxveW1lbnRDb25maWc/OiBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwQmx1ZUdyZWVuRGVwbG95bWVudENvbmZpZ1tdO1xuICBwdWJsaWMgZ2V0IGJsdWVHcmVlbkRlcGxveW1lbnRDb25maWcoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2JsdWVHcmVlbkRlcGxveW1lbnRDb25maWc7XG4gIH1cbiAgcHVibGljIHNldCBibHVlR3JlZW5EZXBsb3ltZW50Q29uZmlnKHZhbHVlOiBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwQmx1ZUdyZWVuRGVwbG95bWVudENvbmZpZ1tdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fYmx1ZUdyZWVuRGVwbG95bWVudENvbmZpZyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gZGVwbG95bWVudF9zdHlsZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZXBsb3ltZW50U3R5bGU/OiBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwRGVwbG95bWVudFN0eWxlW107XG4gIHB1YmxpYyBnZXQgZGVwbG95bWVudFN0eWxlKCkge1xuICAgIHJldHVybiB0aGlzLl9kZXBsb3ltZW50U3R5bGU7XG4gIH1cbiAgcHVibGljIHNldCBkZXBsb3ltZW50U3R5bGUodmFsdWU6IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBEZXBsb3ltZW50U3R5bGVbXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2RlcGxveW1lbnRTdHlsZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gZWMyX3RhZ19maWx0ZXIgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZWMyVGFnRmlsdGVyPzogQ29kZWRlcGxveURlcGxveW1lbnRHcm91cEVjMlRhZ0ZpbHRlcltdO1xuICBwdWJsaWMgZ2V0IGVjMlRhZ0ZpbHRlcigpIHtcbiAgICByZXR1cm4gdGhpcy5fZWMyVGFnRmlsdGVyO1xuICB9XG4gIHB1YmxpYyBzZXQgZWMyVGFnRmlsdGVyKHZhbHVlOiBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwRWMyVGFnRmlsdGVyW10gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9lYzJUYWdGaWx0ZXIgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGVjMl90YWdfc2V0IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2VjMlRhZ1NldD86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBFYzJUYWdTZXRbXTtcbiAgcHVibGljIGdldCBlYzJUYWdTZXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2VjMlRhZ1NldDtcbiAgfVxuICBwdWJsaWMgc2V0IGVjMlRhZ1NldCh2YWx1ZTogQ29kZWRlcGxveURlcGxveW1lbnRHcm91cEVjMlRhZ1NldFtdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fZWMyVGFnU2V0ID0gdmFsdWU7XG4gIH1cblxuICAvLyBlY3Nfc2VydmljZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9lY3NTZXJ2aWNlPzogQ29kZWRlcGxveURlcGxveW1lbnRHcm91cEVjc1NlcnZpY2VbXTtcbiAgcHVibGljIGdldCBlY3NTZXJ2aWNlKCkge1xuICAgIHJldHVybiB0aGlzLl9lY3NTZXJ2aWNlO1xuICB9XG4gIHB1YmxpYyBzZXQgZWNzU2VydmljZSh2YWx1ZTogQ29kZWRlcGxveURlcGxveW1lbnRHcm91cEVjc1NlcnZpY2VbXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2Vjc1NlcnZpY2UgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGxvYWRfYmFsYW5jZXJfaW5mbyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9sb2FkQmFsYW5jZXJJbmZvPzogQ29kZWRlcGxveURlcGxveW1lbnRHcm91cExvYWRCYWxhbmNlckluZm9bXTtcbiAgcHVibGljIGdldCBsb2FkQmFsYW5jZXJJbmZvKCkge1xuICAgIHJldHVybiB0aGlzLl9sb2FkQmFsYW5jZXJJbmZvO1xuICB9XG4gIHB1YmxpYyBzZXQgbG9hZEJhbGFuY2VySW5mbyh2YWx1ZTogQ29kZWRlcGxveURlcGxveW1lbnRHcm91cExvYWRCYWxhbmNlckluZm9bXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2xvYWRCYWxhbmNlckluZm8gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIG9uX3ByZW1pc2VzX2luc3RhbmNlX3RhZ19maWx0ZXIgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfb25QcmVtaXNlc0luc3RhbmNlVGFnRmlsdGVyPzogQ29kZWRlcGxveURlcGxveW1lbnRHcm91cE9uUHJlbWlzZXNJbnN0YW5jZVRhZ0ZpbHRlcltdO1xuICBwdWJsaWMgZ2V0IG9uUHJlbWlzZXNJbnN0YW5jZVRhZ0ZpbHRlcigpIHtcbiAgICByZXR1cm4gdGhpcy5fb25QcmVtaXNlc0luc3RhbmNlVGFnRmlsdGVyO1xuICB9XG4gIHB1YmxpYyBzZXQgb25QcmVtaXNlc0luc3RhbmNlVGFnRmlsdGVyKHZhbHVlOiBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwT25QcmVtaXNlc0luc3RhbmNlVGFnRmlsdGVyW10gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9vblByZW1pc2VzSW5zdGFuY2VUYWdGaWx0ZXIgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHRyaWdnZXJfY29uZmlndXJhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90cmlnZ2VyQ29uZmlndXJhdGlvbj86IENvZGVkZXBsb3lEZXBsb3ltZW50R3JvdXBUcmlnZ2VyQ29uZmlndXJhdGlvbltdO1xuICBwdWJsaWMgZ2V0IHRyaWdnZXJDb25maWd1cmF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLl90cmlnZ2VyQ29uZmlndXJhdGlvbjtcbiAgfVxuICBwdWJsaWMgc2V0IHRyaWdnZXJDb25maWd1cmF0aW9uKHZhbHVlOiBDb2RlZGVwbG95RGVwbG95bWVudEdyb3VwVHJpZ2dlckNvbmZpZ3VyYXRpb25bXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3RyaWdnZXJDb25maWd1cmF0aW9uID0gdmFsdWU7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHB1YmxpYyBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGFwcF9uYW1lOiB0aGlzLl9hcHBOYW1lLFxuICAgICAgYXV0b3NjYWxpbmdfZ3JvdXBzOiB0aGlzLl9hdXRvc2NhbGluZ0dyb3VwcyxcbiAgICAgIGRlcGxveW1lbnRfY29uZmlnX25hbWU6IHRoaXMuX2RlcGxveW1lbnRDb25maWdOYW1lLFxuICAgICAgZGVwbG95bWVudF9ncm91cF9uYW1lOiB0aGlzLl9kZXBsb3ltZW50R3JvdXBOYW1lLFxuICAgICAgc2VydmljZV9yb2xlX2FybjogdGhpcy5fc2VydmljZVJvbGVBcm4sXG4gICAgICBhbGFybV9jb25maWd1cmF0aW9uOiB0aGlzLl9hbGFybUNvbmZpZ3VyYXRpb24sXG4gICAgICBhdXRvX3JvbGxiYWNrX2NvbmZpZ3VyYXRpb246IHRoaXMuX2F1dG9Sb2xsYmFja0NvbmZpZ3VyYXRpb24sXG4gICAgICBibHVlX2dyZWVuX2RlcGxveW1lbnRfY29uZmlnOiB0aGlzLl9ibHVlR3JlZW5EZXBsb3ltZW50Q29uZmlnLFxuICAgICAgZGVwbG95bWVudF9zdHlsZTogdGhpcy5fZGVwbG95bWVudFN0eWxlLFxuICAgICAgZWMyX3RhZ19maWx0ZXI6IHRoaXMuX2VjMlRhZ0ZpbHRlcixcbiAgICAgIGVjMl90YWdfc2V0OiB0aGlzLl9lYzJUYWdTZXQsXG4gICAgICBlY3Nfc2VydmljZTogdGhpcy5fZWNzU2VydmljZSxcbiAgICAgIGxvYWRfYmFsYW5jZXJfaW5mbzogdGhpcy5fbG9hZEJhbGFuY2VySW5mbyxcbiAgICAgIG9uX3ByZW1pc2VzX2luc3RhbmNlX3RhZ19maWx0ZXI6IHRoaXMuX29uUHJlbWlzZXNJbnN0YW5jZVRhZ0ZpbHRlcixcbiAgICAgIHRyaWdnZXJfY29uZmlndXJhdGlvbjogdGhpcy5fdHJpZ2dlckNvbmZpZ3VyYXRpb24sXG4gICAgfTtcbiAgfVxufVxuIl19