import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CodepipelineWebhookConfig extends TerraformMetaArguments {
    readonly authentication: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly targetAction: string;
    readonly targetPipeline: string;
    /** authentication_configuration block */
    readonly authenticationConfiguration?: CodepipelineWebhookAuthenticationConfiguration[];
    /** filter block */
    readonly filter: CodepipelineWebhookFilter[];
}
export interface CodepipelineWebhookAuthenticationConfiguration {
    readonly allowedIpRange?: string;
    readonly secretToken?: string;
}
export interface CodepipelineWebhookFilter {
    readonly jsonPath: string;
    readonly matchEquals: string;
}
export declare class CodepipelineWebhook extends TerraformResource {
    constructor(scope: Construct, id: string, config: CodepipelineWebhookConfig);
    private _authentication;
    get authentication(): string;
    set authentication(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _targetAction;
    get targetAction(): string;
    set targetAction(value: string);
    private _targetPipeline;
    get targetPipeline(): string;
    set targetPipeline(value: string);
    get url(): string;
    private _authenticationConfiguration?;
    get authenticationConfiguration(): CodepipelineWebhookAuthenticationConfiguration[] | undefined;
    set authenticationConfiguration(value: CodepipelineWebhookAuthenticationConfiguration[] | undefined);
    private _filter;
    get filter(): CodepipelineWebhookFilter[];
    set filter(value: CodepipelineWebhookFilter[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
