import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CodepipelineConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly roleArn: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** artifact_store block */
    readonly artifactStore: CodepipelineArtifactStore[];
    /** stage block */
    readonly stage: CodepipelineStage[];
}
export interface CodepipelineArtifactStoreEncryptionKey {
    readonly id: string;
    readonly type: string;
}
export interface CodepipelineArtifactStore {
    readonly location: string;
    readonly region?: string;
    readonly type: string;
    /** encryption_key block */
    readonly encryptionKey?: CodepipelineArtifactStoreEncryptionKey[];
}
export interface CodepipelineStageAction {
    readonly category: string;
    readonly configuration?: {
        [key: string]: string;
    };
    readonly inputArtifacts?: string[];
    readonly name: string;
    readonly namespace?: string;
    readonly outputArtifacts?: string[];
    readonly owner: string;
    readonly provider: string;
    readonly region?: string;
    readonly roleArn?: string;
    readonly runOrder?: number;
    readonly version: string;
}
export interface CodepipelineStage {
    readonly name: string;
    /** action block */
    readonly action: CodepipelineStageAction[];
}
export declare class Codepipeline extends TerraformResource {
    constructor(scope: Construct, id: string, config: CodepipelineConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _roleArn;
    get roleArn(): string;
    set roleArn(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _artifactStore;
    get artifactStore(): CodepipelineArtifactStore[];
    set artifactStore(value: CodepipelineArtifactStore[]);
    private _stage;
    get stage(): CodepipelineStage[];
    set stage(value: CodepipelineStage[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
