import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CodestarnotificationsNotificationRuleConfig extends TerraformMetaArguments {
    readonly detailType: string;
    readonly eventTypeIds: string[];
    readonly name: string;
    readonly resource: string;
    readonly status?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** target block */
    readonly target?: CodestarnotificationsNotificationRuleTarget[];
}
export interface CodestarnotificationsNotificationRuleTarget {
    readonly address: string;
    readonly type?: string;
}
export declare class CodestarnotificationsNotificationRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: CodestarnotificationsNotificationRuleConfig);
    get arn(): string;
    private _detailType;
    get detailType(): string;
    set detailType(value: string);
    private _eventTypeIds;
    get eventTypeIds(): string[];
    set eventTypeIds(value: string[]);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _resource;
    get resource(): string;
    set resource(value: string);
    private _status?;
    get status(): string | undefined;
    set status(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _target?;
    get target(): CodestarnotificationsNotificationRuleTarget[] | undefined;
    set target(value: CodestarnotificationsNotificationRuleTarget[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
