import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CognitoIdentityPoolRolesAttachmentConfig extends TerraformMetaArguments {
    readonly identityPoolId: string;
    readonly roles: {
        [key: string]: string;
    };
    /** role_mapping block */
    readonly roleMapping?: CognitoIdentityPoolRolesAttachmentRoleMapping[];
}
export interface CognitoIdentityPoolRolesAttachmentRoleMappingMappingRule {
    readonly claim: string;
    readonly matchType: string;
    readonly roleArn: string;
    readonly value: string;
}
export interface CognitoIdentityPoolRolesAttachmentRoleMapping {
    readonly ambiguousRoleResolution?: string;
    readonly identityProvider: string;
    readonly type: string;
    /** mapping_rule block */
    readonly mappingRule?: CognitoIdentityPoolRolesAttachmentRoleMappingMappingRule[];
}
export declare class CognitoIdentityPoolRolesAttachment extends TerraformResource {
    constructor(scope: Construct, id: string, config: CognitoIdentityPoolRolesAttachmentConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _identityPoolId;
    get identityPoolId(): string;
    set identityPoolId(value: string);
    private _roles;
    get roles(): {
        [key: string]: string;
    };
    set roles(value: {
        [key: string]: string;
    });
    private _roleMapping?;
    get roleMapping(): CognitoIdentityPoolRolesAttachmentRoleMapping[] | undefined;
    set roleMapping(value: CognitoIdentityPoolRolesAttachmentRoleMapping[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
