import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CognitoIdentityPoolConfig extends TerraformMetaArguments {
    readonly allowUnauthenticatedIdentities?: boolean;
    readonly developerProviderName?: string;
    readonly identityPoolName: string;
    readonly openidConnectProviderArns?: string[];
    readonly samlProviderArns?: string[];
    readonly supportedLoginProviders?: {
        [key: string]: string;
    };
    readonly tags?: {
        [key: string]: string;
    };
    /** cognito_identity_providers block */
    readonly cognitoIdentityProviders?: CognitoIdentityPoolCognitoIdentityProviders[];
}
export interface CognitoIdentityPoolCognitoIdentityProviders {
    readonly clientId?: string;
    readonly providerName?: string;
    readonly serverSideTokenCheck?: boolean;
}
export declare class CognitoIdentityPool extends TerraformResource {
    constructor(scope: Construct, id: string, config: CognitoIdentityPoolConfig);
    private _allowUnauthenticatedIdentities?;
    get allowUnauthenticatedIdentities(): boolean | undefined;
    set allowUnauthenticatedIdentities(value: boolean | undefined);
    get arn(): string;
    private _developerProviderName?;
    get developerProviderName(): string | undefined;
    set developerProviderName(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _identityPoolName;
    get identityPoolName(): string;
    set identityPoolName(value: string);
    private _openidConnectProviderArns?;
    get openidConnectProviderArns(): string[] | undefined;
    set openidConnectProviderArns(value: string[] | undefined);
    private _samlProviderArns?;
    get samlProviderArns(): string[] | undefined;
    set samlProviderArns(value: string[] | undefined);
    private _supportedLoginProviders?;
    get supportedLoginProviders(): {
        [key: string]: string;
    } | undefined;
    set supportedLoginProviders(value: {
        [key: string]: string;
    } | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _cognitoIdentityProviders?;
    get cognitoIdentityProviders(): CognitoIdentityPoolCognitoIdentityProviders[] | undefined;
    set cognitoIdentityProviders(value: CognitoIdentityPoolCognitoIdentityProviders[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
