"use strict";
// https://www.terraform.io/docs/providers/aws/r/cognito_identity_pool.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.CognitoIdentityPool = void 0;
const cdktf_1 = require("cdktf");
// Resource
class CognitoIdentityPool extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_cognito_identity_pool',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._allowUnauthenticatedIdentities = config.allowUnauthenticatedIdentities;
        this._developerProviderName = config.developerProviderName;
        this._identityPoolName = config.identityPoolName;
        this._openidConnectProviderArns = config.openidConnectProviderArns;
        this._samlProviderArns = config.samlProviderArns;
        this._supportedLoginProviders = config.supportedLoginProviders;
        this._tags = config.tags;
        this._cognitoIdentityProviders = config.cognitoIdentityProviders;
    }
    get allowUnauthenticatedIdentities() {
        return this._allowUnauthenticatedIdentities;
    }
    set allowUnauthenticatedIdentities(value) {
        this._allowUnauthenticatedIdentities = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get developerProviderName() {
        return this._developerProviderName;
    }
    set developerProviderName(value) {
        this._developerProviderName = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get identityPoolName() {
        return this._identityPoolName;
    }
    set identityPoolName(value) {
        this._identityPoolName = value;
    }
    get openidConnectProviderArns() {
        return this._openidConnectProviderArns;
    }
    set openidConnectProviderArns(value) {
        this._openidConnectProviderArns = value;
    }
    get samlProviderArns() {
        return this._samlProviderArns;
    }
    set samlProviderArns(value) {
        this._samlProviderArns = value;
    }
    get supportedLoginProviders() {
        return this._supportedLoginProviders;
    }
    set supportedLoginProviders(value) {
        this._supportedLoginProviders = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get cognitoIdentityProviders() {
        return this._cognitoIdentityProviders;
    }
    set cognitoIdentityProviders(value) {
        this._cognitoIdentityProviders = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_unauthenticated_identities: this._allowUnauthenticatedIdentities,
            developer_provider_name: this._developerProviderName,
            identity_pool_name: this._identityPoolName,
            openid_connect_provider_arns: this._openidConnectProviderArns,
            saml_provider_arns: this._samlProviderArns,
            supported_login_providers: this._supportedLoginProviders,
            tags: this._tags,
            cognito_identity_providers: this._cognitoIdentityProviders,
        };
    }
}
exports.CognitoIdentityPool = CognitoIdentityPool;
//# sourceMappingURL=data:application/json;base64,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