import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CognitoIdentityProviderConfig extends TerraformMetaArguments {
    readonly attributeMapping?: {
        [key: string]: string;
    };
    readonly idpIdentifiers?: string[];
    readonly providerDetails: {
        [key: string]: string;
    };
    readonly providerName: string;
    readonly providerType: string;
    readonly userPoolId: string;
}
export declare class CognitoIdentityProvider extends TerraformResource {
    constructor(scope: Construct, id: string, config: CognitoIdentityProviderConfig);
    private _attributeMapping?;
    get attributeMapping(): {
        [key: string]: string;
    } | undefined;
    set attributeMapping(value: {
        [key: string]: string;
    } | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _idpIdentifiers?;
    get idpIdentifiers(): string[] | undefined;
    set idpIdentifiers(value: string[] | undefined);
    private _providerDetails;
    get providerDetails(): {
        [key: string]: string;
    };
    set providerDetails(value: {
        [key: string]: string;
    });
    private _providerName;
    get providerName(): string;
    set providerName(value: string);
    private _providerType;
    get providerType(): string;
    set providerType(value: string);
    private _userPoolId;
    get userPoolId(): string;
    set userPoolId(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
