import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CognitoResourceServerConfig extends TerraformMetaArguments {
    readonly identifier: string;
    readonly name: string;
    readonly userPoolId: string;
    /** scope block */
    readonly scope?: CognitoResourceServerScope[];
}
export interface CognitoResourceServerScope {
    readonly scopeDescription: string;
    readonly scopeName: string;
}
export declare class CognitoResourceServer extends TerraformResource {
    constructor(scope: Construct, id: string, config: CognitoResourceServerConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _identifier;
    get identifier(): string;
    set identifier(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    get scopeIdentifiers(): string[];
    private _userPoolId;
    get userPoolId(): string;
    set userPoolId(value: string);
    private _scope?;
    get scope(): CognitoResourceServerScope[] | undefined;
    set scope(value: CognitoResourceServerScope[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
