import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CognitoUserPoolClientConfig extends TerraformMetaArguments {
    readonly allowedOauthFlows?: string[];
    readonly allowedOauthFlowsUserPoolClient?: boolean;
    readonly allowedOauthScopes?: string[];
    readonly callbackUrls?: string[];
    readonly defaultRedirectUri?: string;
    readonly explicitAuthFlows?: string[];
    readonly generateSecret?: boolean;
    readonly logoutUrls?: string[];
    readonly name: string;
    readonly preventUserExistenceErrors?: string;
    readonly readAttributes?: string[];
    readonly refreshTokenValidity?: number;
    readonly supportedIdentityProviders?: string[];
    readonly userPoolId: string;
    readonly writeAttributes?: string[];
    /** analytics_configuration block */
    readonly analyticsConfiguration?: CognitoUserPoolClientAnalyticsConfiguration[];
}
export interface CognitoUserPoolClientAnalyticsConfiguration {
    readonly applicationId: string;
    readonly externalId: string;
    readonly roleArn: string;
    readonly userDataShared?: boolean;
}
export declare class CognitoUserPoolClient extends TerraformResource {
    constructor(scope: Construct, id: string, config: CognitoUserPoolClientConfig);
    private _allowedOauthFlows?;
    get allowedOauthFlows(): string[] | undefined;
    set allowedOauthFlows(value: string[] | undefined);
    private _allowedOauthFlowsUserPoolClient?;
    get allowedOauthFlowsUserPoolClient(): boolean | undefined;
    set allowedOauthFlowsUserPoolClient(value: boolean | undefined);
    private _allowedOauthScopes?;
    get allowedOauthScopes(): string[] | undefined;
    set allowedOauthScopes(value: string[] | undefined);
    private _callbackUrls?;
    get callbackUrls(): string[] | undefined;
    set callbackUrls(value: string[] | undefined);
    get clientSecret(): string;
    private _defaultRedirectUri?;
    get defaultRedirectUri(): string | undefined;
    set defaultRedirectUri(value: string | undefined);
    private _explicitAuthFlows?;
    get explicitAuthFlows(): string[] | undefined;
    set explicitAuthFlows(value: string[] | undefined);
    private _generateSecret?;
    get generateSecret(): boolean | undefined;
    set generateSecret(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _logoutUrls?;
    get logoutUrls(): string[] | undefined;
    set logoutUrls(value: string[] | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _preventUserExistenceErrors?;
    get preventUserExistenceErrors(): string | undefined;
    set preventUserExistenceErrors(value: string | undefined);
    private _readAttributes?;
    get readAttributes(): string[] | undefined;
    set readAttributes(value: string[] | undefined);
    private _refreshTokenValidity?;
    get refreshTokenValidity(): number | undefined;
    set refreshTokenValidity(value: number | undefined);
    private _supportedIdentityProviders?;
    get supportedIdentityProviders(): string[] | undefined;
    set supportedIdentityProviders(value: string[] | undefined);
    private _userPoolId;
    get userPoolId(): string;
    set userPoolId(value: string);
    private _writeAttributes?;
    get writeAttributes(): string[] | undefined;
    set writeAttributes(value: string[] | undefined);
    private _analyticsConfiguration?;
    get analyticsConfiguration(): CognitoUserPoolClientAnalyticsConfiguration[] | undefined;
    set analyticsConfiguration(value: CognitoUserPoolClientAnalyticsConfiguration[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
