"use strict";
// https://www.terraform.io/docs/providers/aws/r/cognito_user_pool_client.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.CognitoUserPoolClient = void 0;
const cdktf_1 = require("cdktf");
// Resource
class CognitoUserPoolClient extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_cognito_user_pool_client',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._allowedOauthFlows = config.allowedOauthFlows;
        this._allowedOauthFlowsUserPoolClient = config.allowedOauthFlowsUserPoolClient;
        this._allowedOauthScopes = config.allowedOauthScopes;
        this._callbackUrls = config.callbackUrls;
        this._defaultRedirectUri = config.defaultRedirectUri;
        this._explicitAuthFlows = config.explicitAuthFlows;
        this._generateSecret = config.generateSecret;
        this._logoutUrls = config.logoutUrls;
        this._name = config.name;
        this._preventUserExistenceErrors = config.preventUserExistenceErrors;
        this._readAttributes = config.readAttributes;
        this._refreshTokenValidity = config.refreshTokenValidity;
        this._supportedIdentityProviders = config.supportedIdentityProviders;
        this._userPoolId = config.userPoolId;
        this._writeAttributes = config.writeAttributes;
        this._analyticsConfiguration = config.analyticsConfiguration;
    }
    get allowedOauthFlows() {
        return this._allowedOauthFlows;
    }
    set allowedOauthFlows(value) {
        this._allowedOauthFlows = value;
    }
    get allowedOauthFlowsUserPoolClient() {
        return this._allowedOauthFlowsUserPoolClient;
    }
    set allowedOauthFlowsUserPoolClient(value) {
        this._allowedOauthFlowsUserPoolClient = value;
    }
    get allowedOauthScopes() {
        return this._allowedOauthScopes;
    }
    set allowedOauthScopes(value) {
        this._allowedOauthScopes = value;
    }
    get callbackUrls() {
        return this._callbackUrls;
    }
    set callbackUrls(value) {
        this._callbackUrls = value;
    }
    // client_secret - computed: true, optional: false, required: true
    get clientSecret() {
        return this.getStringAttribute('client_secret');
    }
    get defaultRedirectUri() {
        return this._defaultRedirectUri;
    }
    set defaultRedirectUri(value) {
        this._defaultRedirectUri = value;
    }
    get explicitAuthFlows() {
        return this._explicitAuthFlows;
    }
    set explicitAuthFlows(value) {
        this._explicitAuthFlows = value;
    }
    get generateSecret() {
        return this._generateSecret;
    }
    set generateSecret(value) {
        this._generateSecret = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get logoutUrls() {
        return this._logoutUrls;
    }
    set logoutUrls(value) {
        this._logoutUrls = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get preventUserExistenceErrors() {
        var _a;
        return (_a = this._preventUserExistenceErrors) !== null && _a !== void 0 ? _a : this.getStringAttribute('prevent_user_existence_errors');
    }
    set preventUserExistenceErrors(value) {
        this._preventUserExistenceErrors = value;
    }
    get readAttributes() {
        return this._readAttributes;
    }
    set readAttributes(value) {
        this._readAttributes = value;
    }
    get refreshTokenValidity() {
        return this._refreshTokenValidity;
    }
    set refreshTokenValidity(value) {
        this._refreshTokenValidity = value;
    }
    get supportedIdentityProviders() {
        return this._supportedIdentityProviders;
    }
    set supportedIdentityProviders(value) {
        this._supportedIdentityProviders = value;
    }
    get userPoolId() {
        return this._userPoolId;
    }
    set userPoolId(value) {
        this._userPoolId = value;
    }
    get writeAttributes() {
        return this._writeAttributes;
    }
    set writeAttributes(value) {
        this._writeAttributes = value;
    }
    get analyticsConfiguration() {
        return this._analyticsConfiguration;
    }
    set analyticsConfiguration(value) {
        this._analyticsConfiguration = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allowed_oauth_flows: this._allowedOauthFlows,
            allowed_oauth_flows_user_pool_client: this._allowedOauthFlowsUserPoolClient,
            allowed_oauth_scopes: this._allowedOauthScopes,
            callback_urls: this._callbackUrls,
            default_redirect_uri: this._defaultRedirectUri,
            explicit_auth_flows: this._explicitAuthFlows,
            generate_secret: this._generateSecret,
            logout_urls: this._logoutUrls,
            name: this._name,
            prevent_user_existence_errors: this._preventUserExistenceErrors,
            read_attributes: this._readAttributes,
            refresh_token_validity: this._refreshTokenValidity,
            supported_identity_providers: this._supportedIdentityProviders,
            user_pool_id: this._userPoolId,
            write_attributes: this._writeAttributes,
            analytics_configuration: this._analyticsConfiguration,
        };
    }
}
exports.CognitoUserPoolClient = CognitoUserPoolClient;
//# sourceMappingURL=data:application/json;base64,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