import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CognitoUserPoolDomainConfig extends TerraformMetaArguments {
    readonly certificateArn?: string;
    readonly domain: string;
    readonly userPoolId: string;
}
export declare class CognitoUserPoolDomain extends TerraformResource {
    constructor(scope: Construct, id: string, config: CognitoUserPoolDomainConfig);
    get awsAccountId(): string;
    private _certificateArn?;
    get certificateArn(): string | undefined;
    set certificateArn(value: string | undefined);
    get cloudfrontDistributionArn(): string;
    private _domain;
    get domain(): string;
    set domain(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get s3Bucket(): string;
    private _userPoolId;
    get userPoolId(): string;
    set userPoolId(value: string);
    get version(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
