import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CognitoUserPoolConfig extends TerraformMetaArguments {
    readonly aliasAttributes?: string[];
    readonly autoVerifiedAttributes?: string[];
    readonly emailVerificationMessage?: string;
    readonly emailVerificationSubject?: string;
    readonly mfaConfiguration?: string;
    readonly name: string;
    readonly smsAuthenticationMessage?: string;
    readonly smsVerificationMessage?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly usernameAttributes?: string[];
    /** admin_create_user_config block */
    readonly adminCreateUserConfig?: CognitoUserPoolAdminCreateUserConfig[];
    /** device_configuration block */
    readonly deviceConfiguration?: CognitoUserPoolDeviceConfiguration[];
    /** email_configuration block */
    readonly emailConfiguration?: CognitoUserPoolEmailConfiguration[];
    /** lambda_config block */
    readonly lambdaConfig?: CognitoUserPoolLambdaConfig[];
    /** password_policy block */
    readonly passwordPolicy?: CognitoUserPoolPasswordPolicy[];
    /** schema block */
    readonly schema?: CognitoUserPoolSchema[];
    /** sms_configuration block */
    readonly smsConfiguration?: CognitoUserPoolSmsConfiguration[];
    /** software_token_mfa_configuration block */
    readonly softwareTokenMfaConfiguration?: CognitoUserPoolSoftwareTokenMfaConfiguration[];
    /** user_pool_add_ons block */
    readonly userPoolAddOns?: CognitoUserPoolUserPoolAddOns[];
    /** username_configuration block */
    readonly usernameConfiguration?: CognitoUserPoolUsernameConfiguration[];
    /** verification_message_template block */
    readonly verificationMessageTemplate?: CognitoUserPoolVerificationMessageTemplate[];
}
export interface CognitoUserPoolAdminCreateUserConfigInviteMessageTemplate {
    readonly emailMessage?: string;
    readonly emailSubject?: string;
    readonly smsMessage?: string;
}
export interface CognitoUserPoolAdminCreateUserConfig {
    readonly allowAdminCreateUserOnly?: boolean;
    readonly unusedAccountValidityDays?: number;
    /** invite_message_template block */
    readonly inviteMessageTemplate?: CognitoUserPoolAdminCreateUserConfigInviteMessageTemplate[];
}
export interface CognitoUserPoolDeviceConfiguration {
    readonly challengeRequiredOnNewDevice?: boolean;
    readonly deviceOnlyRememberedOnUserPrompt?: boolean;
}
export interface CognitoUserPoolEmailConfiguration {
    readonly emailSendingAccount?: string;
    readonly fromEmailAddress?: string;
    readonly replyToEmailAddress?: string;
    readonly sourceArn?: string;
}
export interface CognitoUserPoolLambdaConfig {
    readonly createAuthChallenge?: string;
    readonly customMessage?: string;
    readonly defineAuthChallenge?: string;
    readonly postAuthentication?: string;
    readonly postConfirmation?: string;
    readonly preAuthentication?: string;
    readonly preSignUp?: string;
    readonly preTokenGeneration?: string;
    readonly userMigration?: string;
    readonly verifyAuthChallengeResponse?: string;
}
export interface CognitoUserPoolPasswordPolicy {
    readonly minimumLength?: number;
    readonly requireLowercase?: boolean;
    readonly requireNumbers?: boolean;
    readonly requireSymbols?: boolean;
    readonly requireUppercase?: boolean;
    readonly temporaryPasswordValidityDays?: number;
}
export interface CognitoUserPoolSchemaNumberAttributeConstraints {
    readonly maxValue?: string;
    readonly minValue?: string;
}
export interface CognitoUserPoolSchemaStringAttributeConstraints {
    readonly maxLength?: string;
    readonly minLength?: string;
}
export interface CognitoUserPoolSchema {
    readonly attributeDataType: string;
    readonly developerOnlyAttribute?: boolean;
    readonly mutable?: boolean;
    readonly name: string;
    readonly required?: boolean;
    /** number_attribute_constraints block */
    readonly numberAttributeConstraints?: CognitoUserPoolSchemaNumberAttributeConstraints[];
    /** string_attribute_constraints block */
    readonly stringAttributeConstraints?: CognitoUserPoolSchemaStringAttributeConstraints[];
}
export interface CognitoUserPoolSmsConfiguration {
    readonly externalId: string;
    readonly snsCallerArn: string;
}
export interface CognitoUserPoolSoftwareTokenMfaConfiguration {
    readonly enabled: boolean;
}
export interface CognitoUserPoolUserPoolAddOns {
    readonly advancedSecurityMode: string;
}
export interface CognitoUserPoolUsernameConfiguration {
    readonly caseSensitive: boolean;
}
export interface CognitoUserPoolVerificationMessageTemplate {
    readonly defaultEmailOption?: string;
    readonly emailMessage?: string;
    readonly emailMessageByLink?: string;
    readonly emailSubject?: string;
    readonly emailSubjectByLink?: string;
    readonly smsMessage?: string;
}
export declare class CognitoUserPool extends TerraformResource {
    constructor(scope: Construct, id: string, config: CognitoUserPoolConfig);
    private _aliasAttributes?;
    get aliasAttributes(): string[] | undefined;
    set aliasAttributes(value: string[] | undefined);
    get arn(): string;
    private _autoVerifiedAttributes?;
    get autoVerifiedAttributes(): string[] | undefined;
    set autoVerifiedAttributes(value: string[] | undefined);
    get creationDate(): string;
    private _emailVerificationMessage?;
    get emailVerificationMessage(): string | undefined;
    set emailVerificationMessage(value: string | undefined);
    private _emailVerificationSubject?;
    get emailVerificationSubject(): string | undefined;
    set emailVerificationSubject(value: string | undefined);
    get endpoint(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get lastModifiedDate(): string;
    private _mfaConfiguration?;
    get mfaConfiguration(): string | undefined;
    set mfaConfiguration(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _smsAuthenticationMessage?;
    get smsAuthenticationMessage(): string | undefined;
    set smsAuthenticationMessage(value: string | undefined);
    private _smsVerificationMessage?;
    get smsVerificationMessage(): string | undefined;
    set smsVerificationMessage(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _usernameAttributes?;
    get usernameAttributes(): string[] | undefined;
    set usernameAttributes(value: string[] | undefined);
    private _adminCreateUserConfig?;
    get adminCreateUserConfig(): CognitoUserPoolAdminCreateUserConfig[] | undefined;
    set adminCreateUserConfig(value: CognitoUserPoolAdminCreateUserConfig[] | undefined);
    private _deviceConfiguration?;
    get deviceConfiguration(): CognitoUserPoolDeviceConfiguration[] | undefined;
    set deviceConfiguration(value: CognitoUserPoolDeviceConfiguration[] | undefined);
    private _emailConfiguration?;
    get emailConfiguration(): CognitoUserPoolEmailConfiguration[] | undefined;
    set emailConfiguration(value: CognitoUserPoolEmailConfiguration[] | undefined);
    private _lambdaConfig?;
    get lambdaConfig(): CognitoUserPoolLambdaConfig[] | undefined;
    set lambdaConfig(value: CognitoUserPoolLambdaConfig[] | undefined);
    private _passwordPolicy?;
    get passwordPolicy(): CognitoUserPoolPasswordPolicy[] | undefined;
    set passwordPolicy(value: CognitoUserPoolPasswordPolicy[] | undefined);
    private _schema?;
    get schema(): CognitoUserPoolSchema[] | undefined;
    set schema(value: CognitoUserPoolSchema[] | undefined);
    private _smsConfiguration?;
    get smsConfiguration(): CognitoUserPoolSmsConfiguration[] | undefined;
    set smsConfiguration(value: CognitoUserPoolSmsConfiguration[] | undefined);
    private _softwareTokenMfaConfiguration?;
    get softwareTokenMfaConfiguration(): CognitoUserPoolSoftwareTokenMfaConfiguration[] | undefined;
    set softwareTokenMfaConfiguration(value: CognitoUserPoolSoftwareTokenMfaConfiguration[] | undefined);
    private _userPoolAddOns?;
    get userPoolAddOns(): CognitoUserPoolUserPoolAddOns[] | undefined;
    set userPoolAddOns(value: CognitoUserPoolUserPoolAddOns[] | undefined);
    private _usernameConfiguration?;
    get usernameConfiguration(): CognitoUserPoolUsernameConfiguration[] | undefined;
    set usernameConfiguration(value: CognitoUserPoolUsernameConfiguration[] | undefined);
    private _verificationMessageTemplate?;
    get verificationMessageTemplate(): CognitoUserPoolVerificationMessageTemplate[] | undefined;
    set verificationMessageTemplate(value: CognitoUserPoolVerificationMessageTemplate[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
