"use strict";
// https://www.terraform.io/docs/providers/aws/r/cognito_user_pool.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.CognitoUserPool = void 0;
const cdktf_1 = require("cdktf");
// Resource
class CognitoUserPool extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_cognito_user_pool',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._aliasAttributes = config.aliasAttributes;
        this._autoVerifiedAttributes = config.autoVerifiedAttributes;
        this._emailVerificationMessage = config.emailVerificationMessage;
        this._emailVerificationSubject = config.emailVerificationSubject;
        this._mfaConfiguration = config.mfaConfiguration;
        this._name = config.name;
        this._smsAuthenticationMessage = config.smsAuthenticationMessage;
        this._smsVerificationMessage = config.smsVerificationMessage;
        this._tags = config.tags;
        this._usernameAttributes = config.usernameAttributes;
        this._adminCreateUserConfig = config.adminCreateUserConfig;
        this._deviceConfiguration = config.deviceConfiguration;
        this._emailConfiguration = config.emailConfiguration;
        this._lambdaConfig = config.lambdaConfig;
        this._passwordPolicy = config.passwordPolicy;
        this._schema = config.schema;
        this._smsConfiguration = config.smsConfiguration;
        this._softwareTokenMfaConfiguration = config.softwareTokenMfaConfiguration;
        this._userPoolAddOns = config.userPoolAddOns;
        this._usernameConfiguration = config.usernameConfiguration;
        this._verificationMessageTemplate = config.verificationMessageTemplate;
    }
    get aliasAttributes() {
        return this._aliasAttributes;
    }
    set aliasAttributes(value) {
        this._aliasAttributes = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get autoVerifiedAttributes() {
        return this._autoVerifiedAttributes;
    }
    set autoVerifiedAttributes(value) {
        this._autoVerifiedAttributes = value;
    }
    // creation_date - computed: true, optional: false, required: true
    get creationDate() {
        return this.getStringAttribute('creation_date');
    }
    get emailVerificationMessage() {
        var _a;
        return (_a = this._emailVerificationMessage) !== null && _a !== void 0 ? _a : this.getStringAttribute('email_verification_message');
    }
    set emailVerificationMessage(value) {
        this._emailVerificationMessage = value;
    }
    get emailVerificationSubject() {
        var _a;
        return (_a = this._emailVerificationSubject) !== null && _a !== void 0 ? _a : this.getStringAttribute('email_verification_subject');
    }
    set emailVerificationSubject(value) {
        this._emailVerificationSubject = value;
    }
    // endpoint - computed: true, optional: false, required: true
    get endpoint() {
        return this.getStringAttribute('endpoint');
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    // last_modified_date - computed: true, optional: false, required: true
    get lastModifiedDate() {
        return this.getStringAttribute('last_modified_date');
    }
    get mfaConfiguration() {
        return this._mfaConfiguration;
    }
    set mfaConfiguration(value) {
        this._mfaConfiguration = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get smsAuthenticationMessage() {
        return this._smsAuthenticationMessage;
    }
    set smsAuthenticationMessage(value) {
        this._smsAuthenticationMessage = value;
    }
    get smsVerificationMessage() {
        var _a;
        return (_a = this._smsVerificationMessage) !== null && _a !== void 0 ? _a : this.getStringAttribute('sms_verification_message');
    }
    set smsVerificationMessage(value) {
        this._smsVerificationMessage = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get usernameAttributes() {
        return this._usernameAttributes;
    }
    set usernameAttributes(value) {
        this._usernameAttributes = value;
    }
    get adminCreateUserConfig() {
        return this._adminCreateUserConfig;
    }
    set adminCreateUserConfig(value) {
        this._adminCreateUserConfig = value;
    }
    get deviceConfiguration() {
        return this._deviceConfiguration;
    }
    set deviceConfiguration(value) {
        this._deviceConfiguration = value;
    }
    get emailConfiguration() {
        return this._emailConfiguration;
    }
    set emailConfiguration(value) {
        this._emailConfiguration = value;
    }
    get lambdaConfig() {
        return this._lambdaConfig;
    }
    set lambdaConfig(value) {
        this._lambdaConfig = value;
    }
    get passwordPolicy() {
        return this._passwordPolicy;
    }
    set passwordPolicy(value) {
        this._passwordPolicy = value;
    }
    get schema() {
        return this._schema;
    }
    set schema(value) {
        this._schema = value;
    }
    get smsConfiguration() {
        return this._smsConfiguration;
    }
    set smsConfiguration(value) {
        this._smsConfiguration = value;
    }
    get softwareTokenMfaConfiguration() {
        return this._softwareTokenMfaConfiguration;
    }
    set softwareTokenMfaConfiguration(value) {
        this._softwareTokenMfaConfiguration = value;
    }
    get userPoolAddOns() {
        return this._userPoolAddOns;
    }
    set userPoolAddOns(value) {
        this._userPoolAddOns = value;
    }
    get usernameConfiguration() {
        return this._usernameConfiguration;
    }
    set usernameConfiguration(value) {
        this._usernameConfiguration = value;
    }
    get verificationMessageTemplate() {
        return this._verificationMessageTemplate;
    }
    set verificationMessageTemplate(value) {
        this._verificationMessageTemplate = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            alias_attributes: this._aliasAttributes,
            auto_verified_attributes: this._autoVerifiedAttributes,
            email_verification_message: this._emailVerificationMessage,
            email_verification_subject: this._emailVerificationSubject,
            mfa_configuration: this._mfaConfiguration,
            name: this._name,
            sms_authentication_message: this._smsAuthenticationMessage,
            sms_verification_message: this._smsVerificationMessage,
            tags: this._tags,
            username_attributes: this._usernameAttributes,
            admin_create_user_config: this._adminCreateUserConfig,
            device_configuration: this._deviceConfiguration,
            email_configuration: this._emailConfiguration,
            lambda_config: this._lambdaConfig,
            password_policy: this._passwordPolicy,
            schema: this._schema,
            sms_configuration: this._smsConfiguration,
            software_token_mfa_configuration: this._softwareTokenMfaConfiguration,
            user_pool_add_ons: this._userPoolAddOns,
            username_configuration: this._usernameConfiguration,
            verification_message_template: this._verificationMessageTemplate,
        };
    }
}
exports.CognitoUserPool = CognitoUserPool;
//# sourceMappingURL=data:application/json;base64,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