import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ConfigConfigRuleConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly inputParameters?: string;
    readonly maximumExecutionFrequency?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** scope block */
    readonly scope?: ConfigConfigRuleScope[];
    /** source block */
    readonly source: ConfigConfigRuleSource[];
}
export interface ConfigConfigRuleScope {
    readonly complianceResourceId?: string;
    readonly complianceResourceTypes?: string[];
    readonly tagKey?: string;
    readonly tagValue?: string;
}
export interface ConfigConfigRuleSourceSourceDetail {
    readonly eventSource?: string;
    readonly maximumExecutionFrequency?: string;
    readonly messageType?: string;
}
export interface ConfigConfigRuleSource {
    readonly owner: string;
    readonly sourceIdentifier: string;
    /** source_detail block */
    readonly sourceDetail?: ConfigConfigRuleSourceSourceDetail[];
}
export declare class ConfigConfigRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: ConfigConfigRuleConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _inputParameters?;
    get inputParameters(): string | undefined;
    set inputParameters(value: string | undefined);
    private _maximumExecutionFrequency?;
    get maximumExecutionFrequency(): string | undefined;
    set maximumExecutionFrequency(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    get ruleId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _scope?;
    get scope(): ConfigConfigRuleScope[] | undefined;
    set scope(value: ConfigConfigRuleScope[] | undefined);
    private _source;
    get source(): ConfigConfigRuleSource[];
    set source(value: ConfigConfigRuleSource[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
