import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ConfigConfigurationAggregatorConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** account_aggregation_source block */
    readonly accountAggregationSource?: ConfigConfigurationAggregatorAccountAggregationSource[];
    /** organization_aggregation_source block */
    readonly organizationAggregationSource?: ConfigConfigurationAggregatorOrganizationAggregationSource[];
}
export interface ConfigConfigurationAggregatorAccountAggregationSource {
    readonly accountIds: string[];
    readonly allRegions?: boolean;
    readonly regions?: string[];
}
export interface ConfigConfigurationAggregatorOrganizationAggregationSource {
    readonly allRegions?: boolean;
    readonly regions?: string[];
    readonly roleArn: string;
}
export declare class ConfigConfigurationAggregator extends TerraformResource {
    constructor(scope: Construct, id: string, config: ConfigConfigurationAggregatorConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _accountAggregationSource?;
    get accountAggregationSource(): ConfigConfigurationAggregatorAccountAggregationSource[] | undefined;
    set accountAggregationSource(value: ConfigConfigurationAggregatorAccountAggregationSource[] | undefined);
    private _organizationAggregationSource?;
    get organizationAggregationSource(): ConfigConfigurationAggregatorOrganizationAggregationSource[] | undefined;
    set organizationAggregationSource(value: ConfigConfigurationAggregatorOrganizationAggregationSource[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
