import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ConfigDeliveryChannelConfig extends TerraformMetaArguments {
    readonly name?: string;
    readonly s3BucketName: string;
    readonly s3KeyPrefix?: string;
    readonly snsTopicArn?: string;
    /** snapshot_delivery_properties block */
    readonly snapshotDeliveryProperties?: ConfigDeliveryChannelSnapshotDeliveryProperties[];
}
export interface ConfigDeliveryChannelSnapshotDeliveryProperties {
    readonly deliveryFrequency?: string;
}
export declare class ConfigDeliveryChannel extends TerraformResource {
    constructor(scope: Construct, id: string, config: ConfigDeliveryChannelConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _s3BucketName;
    get s3BucketName(): string;
    set s3BucketName(value: string);
    private _s3KeyPrefix?;
    get s3KeyPrefix(): string | undefined;
    set s3KeyPrefix(value: string | undefined);
    private _snsTopicArn?;
    get snsTopicArn(): string | undefined;
    set snsTopicArn(value: string | undefined);
    private _snapshotDeliveryProperties?;
    get snapshotDeliveryProperties(): ConfigDeliveryChannelSnapshotDeliveryProperties[] | undefined;
    set snapshotDeliveryProperties(value: ConfigDeliveryChannelSnapshotDeliveryProperties[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
