import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ConfigOrganizationCustomRuleConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly excludedAccounts?: string[];
    readonly inputParameters?: string;
    readonly lambdaFunctionArn: string;
    readonly maximumExecutionFrequency?: string;
    readonly name: string;
    readonly resourceIdScope?: string;
    readonly resourceTypesScope?: string[];
    readonly tagKeyScope?: string;
    readonly tagValueScope?: string;
    readonly triggerTypes: string[];
    /** timeouts block */
    readonly timeouts?: ConfigOrganizationCustomRuleTimeouts;
}
export interface ConfigOrganizationCustomRuleTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class ConfigOrganizationCustomRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: ConfigOrganizationCustomRuleConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _excludedAccounts?;
    get excludedAccounts(): string[] | undefined;
    set excludedAccounts(value: string[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _inputParameters?;
    get inputParameters(): string | undefined;
    set inputParameters(value: string | undefined);
    private _lambdaFunctionArn;
    get lambdaFunctionArn(): string;
    set lambdaFunctionArn(value: string);
    private _maximumExecutionFrequency?;
    get maximumExecutionFrequency(): string | undefined;
    set maximumExecutionFrequency(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _resourceIdScope?;
    get resourceIdScope(): string | undefined;
    set resourceIdScope(value: string | undefined);
    private _resourceTypesScope?;
    get resourceTypesScope(): string[] | undefined;
    set resourceTypesScope(value: string[] | undefined);
    private _tagKeyScope?;
    get tagKeyScope(): string | undefined;
    set tagKeyScope(value: string | undefined);
    private _tagValueScope?;
    get tagValueScope(): string | undefined;
    set tagValueScope(value: string | undefined);
    private _triggerTypes;
    get triggerTypes(): string[];
    set triggerTypes(value: string[]);
    private _timeouts?;
    get timeouts(): ConfigOrganizationCustomRuleTimeouts | undefined;
    set timeouts(value: ConfigOrganizationCustomRuleTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
