import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface ConfigOrganizationManagedRuleConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly excludedAccounts?: string[];
    readonly inputParameters?: string;
    readonly maximumExecutionFrequency?: string;
    readonly name: string;
    readonly resourceIdScope?: string;
    readonly resourceTypesScope?: string[];
    readonly ruleIdentifier: string;
    readonly tagKeyScope?: string;
    readonly tagValueScope?: string;
    /** timeouts block */
    readonly timeouts?: ConfigOrganizationManagedRuleTimeouts;
}
export interface ConfigOrganizationManagedRuleTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class ConfigOrganizationManagedRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: ConfigOrganizationManagedRuleConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _excludedAccounts?;
    get excludedAccounts(): string[] | undefined;
    set excludedAccounts(value: string[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _inputParameters?;
    get inputParameters(): string | undefined;
    set inputParameters(value: string | undefined);
    private _maximumExecutionFrequency?;
    get maximumExecutionFrequency(): string | undefined;
    set maximumExecutionFrequency(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _resourceIdScope?;
    get resourceIdScope(): string | undefined;
    set resourceIdScope(value: string | undefined);
    private _resourceTypesScope?;
    get resourceTypesScope(): string[] | undefined;
    set resourceTypesScope(value: string[] | undefined);
    private _ruleIdentifier;
    get ruleIdentifier(): string;
    set ruleIdentifier(value: string);
    private _tagKeyScope?;
    get tagKeyScope(): string | undefined;
    set tagKeyScope(value: string | undefined);
    private _tagValueScope?;
    get tagValueScope(): string | undefined;
    set tagValueScope(value: string | undefined);
    private _timeouts?;
    get timeouts(): ConfigOrganizationManagedRuleTimeouts | undefined;
    set timeouts(value: ConfigOrganizationManagedRuleTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
