"use strict";
// https://www.terraform.io/docs/providers/aws/r/cur_report_definition.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.CurReportDefinition = void 0;
const cdktf_1 = require("cdktf");
// Resource
class CurReportDefinition extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_cur_report_definition',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._additionalArtifacts = config.additionalArtifacts;
        this._additionalSchemaElements = config.additionalSchemaElements;
        this._compression = config.compression;
        this._format = config.format;
        this._reportName = config.reportName;
        this._s3Bucket = config.s3Bucket;
        this._s3Prefix = config.s3Prefix;
        this._s3Region = config.s3Region;
        this._timeUnit = config.timeUnit;
    }
    get additionalArtifacts() {
        return this._additionalArtifacts;
    }
    set additionalArtifacts(value) {
        this._additionalArtifacts = value;
    }
    get additionalSchemaElements() {
        return this._additionalSchemaElements;
    }
    set additionalSchemaElements(value) {
        this._additionalSchemaElements = value;
    }
    get compression() {
        return this._compression;
    }
    set compression(value) {
        this._compression = value;
    }
    get format() {
        return this._format;
    }
    set format(value) {
        this._format = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get reportName() {
        return this._reportName;
    }
    set reportName(value) {
        this._reportName = value;
    }
    get s3Bucket() {
        return this._s3Bucket;
    }
    set s3Bucket(value) {
        this._s3Bucket = value;
    }
    get s3Prefix() {
        return this._s3Prefix;
    }
    set s3Prefix(value) {
        this._s3Prefix = value;
    }
    get s3Region() {
        return this._s3Region;
    }
    set s3Region(value) {
        this._s3Region = value;
    }
    get timeUnit() {
        return this._timeUnit;
    }
    set timeUnit(value) {
        this._timeUnit = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            additional_artifacts: this._additionalArtifacts,
            additional_schema_elements: this._additionalSchemaElements,
            compression: this._compression,
            format: this._format,
            report_name: this._reportName,
            s3_bucket: this._s3Bucket,
            s3_prefix: this._s3Prefix,
            s3_region: this._s3Region,
            time_unit: this._timeUnit,
        };
    }
}
exports.CurReportDefinition = CurReportDefinition;
//# sourceMappingURL=data:application/json;base64,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