import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface CustomerGatewayConfig extends TerraformMetaArguments {
    readonly bgpAsn: string;
    readonly ipAddress: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly type: string;
}
export declare class CustomerGateway extends TerraformResource {
    constructor(scope: Construct, id: string, config: CustomerGatewayConfig);
    get arn(): string;
    private _bgpAsn;
    get bgpAsn(): string;
    set bgpAsn(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ipAddress;
    get ipAddress(): string;
    set ipAddress(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _type;
    get type(): string;
    set type(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
