import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsAlbListenerConfig extends TerraformMetaArguments {
    readonly loadBalancerArn?: string;
    readonly port?: number;
}
export declare class DataAwsAlbListenerDefaultActionAuthenticateCognito extends ComplexComputedList {
    get authenticationRequestExtraParams(): any;
    get onUnauthenticatedRequest(): string;
    get scope(): string;
    get sessionCookieName(): string;
    get sessionTimeout(): number;
    get userPoolArn(): string;
    get userPoolClientId(): string;
    get userPoolDomain(): string;
}
export declare class DataAwsAlbListenerDefaultActionAuthenticateOidc extends ComplexComputedList {
    get authenticationRequestExtraParams(): any;
    get authorizationEndpoint(): string;
    get clientId(): string;
    get clientSecret(): string;
    get issuer(): string;
    get onUnauthenticatedRequest(): string;
    get scope(): string;
    get sessionCookieName(): string;
    get sessionTimeout(): number;
    get tokenEndpoint(): string;
    get userInfoEndpoint(): string;
}
export declare class DataAwsAlbListenerDefaultActionFixedResponse extends ComplexComputedList {
    get contentType(): string;
    get messageBody(): string;
    get statusCode(): string;
}
export declare class DataAwsAlbListenerDefaultActionRedirect extends ComplexComputedList {
    get host(): string;
    get path(): string;
    get port(): string;
    get protocol(): string;
    get query(): string;
    get statusCode(): string;
}
export declare class DataAwsAlbListenerDefaultAction extends ComplexComputedList {
    get authenticateCognito(): any;
    get authenticateOidc(): any;
    get fixedResponse(): any;
    get order(): number;
    get redirect(): any;
    get targetGroupArn(): string;
    get type(): string;
}
export declare class DataAwsAlbListener extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsAlbListenerConfig);
    private _arn?;
    get arn(): string | undefined;
    set arn(value: string | undefined);
    get certificateArn(): string;
    defaultAction(index: string): DataAwsAlbListenerDefaultAction;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _loadBalancerArn?;
    get loadBalancerArn(): string | undefined;
    set loadBalancerArn(value: string | undefined);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    get protocol(): string;
    get sslPolicy(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
