import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsAlbTargetGroupConfig extends TerraformMetaArguments {
    readonly name?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsAlbTargetGroupHealthCheck extends ComplexComputedList {
    get enabled(): boolean;
    get healthyThreshold(): number;
    get interval(): number;
    get matcher(): string;
    get path(): string;
    get port(): string;
    get protocol(): string;
    get timeout(): number;
    get unhealthyThreshold(): number;
}
export declare class DataAwsAlbTargetGroupStickiness extends ComplexComputedList {
    get cookieDuration(): number;
    get enabled(): boolean;
    get type(): string;
}
export declare class DataAwsAlbTargetGroup extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsAlbTargetGroupConfig);
    private _arn?;
    get arn(): string | undefined;
    set arn(value: string | undefined);
    get arnSuffix(): string;
    get deregistrationDelay(): number;
    healthCheck(index: string): DataAwsAlbTargetGroupHealthCheck;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get lambdaMultiValueHeadersEnabled(): boolean;
    get loadBalancingAlgorithmType(): string;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    get port(): number;
    get protocol(): string;
    get proxyProtocolV2(): boolean;
    get slowStart(): number;
    stickiness(index: string): DataAwsAlbTargetGroupStickiness;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get targetType(): string;
    get vpcId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
