import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsAlbConfig extends TerraformMetaArguments {
    readonly name?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsAlbAccessLogs extends ComplexComputedList {
    get bucket(): string;
    get enabled(): boolean;
    get prefix(): string;
}
export declare class DataAwsAlbSubnetMapping extends ComplexComputedList {
    get allocationId(): string;
    get subnetId(): string;
}
export declare class DataAwsAlb extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsAlbConfig);
    accessLogs(index: string): DataAwsAlbAccessLogs;
    private _arn?;
    get arn(): string | undefined;
    set arn(value: string | undefined);
    get arnSuffix(): string;
    get dnsName(): string;
    get dropInvalidHeaderFields(): boolean;
    get enableDeletionProtection(): boolean;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get idleTimeout(): number;
    get internal(): boolean;
    get ipAddressType(): string;
    get loadBalancerType(): string;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    get securityGroups(): string[];
    subnetMapping(index: string): DataAwsAlbSubnetMapping;
    get subnets(): string[];
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    get zoneId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
